/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.ai;

import com.craftingdead.core.world.effect.ModMobEffects;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class LookAtEntityGoal<T extends Entity>
extends Goal {
    private final Mob goalOwner;
    private final float maxDistance;
    private final float chance;
    private final Class<T> watchedClass;
    private int lookDuration;
    private Entity watchedEntity;

    public LookAtEntityGoal(Mob goalowner, Class<T> watchedClass, float maxDistance) {
        this(goalowner, watchedClass, maxDistance, 0.02f);
    }

    public LookAtEntityGoal(Mob goalOwner, Class<T> watchedClass, float maxDistance, float chance) {
        this.goalOwner = goalOwner;
        this.watchedClass = watchedClass;
        this.maxDistance = maxDistance;
        this.chance = chance;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.goalOwner.m_21023_((MobEffect)ModMobEffects.FLASH_BLINDNESS.get())) {
            return false;
        }
        if (this.goalOwner.m_21187_().nextFloat() >= this.chance) {
            return false;
        }
        List possibleEntities = this.goalOwner.f_19853_.m_45976_(this.watchedClass, this.goalOwner.m_142469_().m_82377_((double)this.maxDistance, 4.0, (double)this.maxDistance));
        double lastSqDistance = Double.MAX_VALUE;
        for (Entity grenade : possibleEntities) {
            double sqDistance = this.goalOwner.m_20280_(grenade);
            if (!(sqDistance <= lastSqDistance)) continue;
            lastSqDistance = sqDistance;
            this.watchedEntity = grenade;
        }
        return this.watchedEntity != null;
    }

    public boolean m_8045_() {
        if (!this.watchedEntity.m_6084_()) {
            return false;
        }
        if (this.goalOwner.m_21023_((MobEffect)ModMobEffects.FLASH_BLINDNESS.get())) {
            return false;
        }
        if (this.goalOwner.m_20280_(this.watchedEntity) > (double)(this.maxDistance * this.maxDistance)) {
            return false;
        }
        return this.lookDuration > 0;
    }

    public void m_8056_() {
        this.lookDuration = 40 + this.goalOwner.m_21187_().nextInt(40);
    }

    public void m_8041_() {
        this.watchedEntity = null;
    }

    public void m_8037_() {
        this.goalOwner.m_21563_().m_24946_(this.watchedEntity.m_20185_(), this.watchedEntity.m_20188_(), this.watchedEntity.m_20189_());
        --this.lookDuration;
    }
}

