/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.extension;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.event.LivingExtensionEvent;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.CancelActionMessage;
import com.craftingdead.core.network.message.play.CrouchMessage;
import com.craftingdead.core.network.message.play.PerformActionMessage;
import com.craftingdead.core.sounds.ModSoundEvents;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.ActionObserver;
import com.craftingdead.core.world.entity.EntityUtil;
import com.craftingdead.core.world.entity.extension.EntitySnapshot;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.entity.extension.LivingHandlerType;
import com.craftingdead.core.world.entity.extension.Visibility;
import com.craftingdead.core.world.inventory.ModEquipmentSlot;
import com.craftingdead.core.world.item.MeleeWeaponItem;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.clothing.Clothing;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.hat.Hat;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

class BaseLivingExtension<E extends LivingEntity, H extends LivingHandler>
implements LivingExtension<E, H> {
    private final E entity;
    protected final Map<LivingHandlerType<? extends H>, H> handlers = new Object2ObjectArrayMap();
    protected final Map<LivingHandlerType<? extends H>, H> dirtyHandlers = new Object2ObjectArrayMap();
    private final IntSet dirtySlots = new IntOpenHashSet();
    private final EntitySnapshot[] snapshots = new EntitySnapshot[20];
    private final ItemStackHandler itemHandler = new ItemStackHandler(ModEquipmentSlot.values().length){

        protected void onLoad() {
            if (this.getSlots() != ModEquipmentSlot.values().length) {
                this.setSize(ModEquipmentSlot.values().length);
            }
        }

        public void onContentsChanged(int slot) {
            if (!BaseLivingExtension.this.getLevel().m_5776_()) {
                BaseLivingExtension.this.dirtySlots.add(slot);
            }
        }
    };
    protected ItemStack lastHeldStack = null;
    protected float[] equipmentDropChances = new float[ModEquipmentSlot.values().length];
    @Nullable
    private Action action;
    @Nullable
    private ActionObserver actionObserver;
    private boolean movementBlocked;
    private boolean crouching;
    private Vec3 lastPos;
    private boolean moving;
    private Visibility cachedVisibility = Visibility.VISIBLE;
    private ItemStack lastClothingStack = ItemStack.f_41583_;

    BaseLivingExtension(E entity) {
        this.entity = entity;
        Arrays.fill(this.equipmentDropChances, 2.0f);
    }

    @Override
    public void load() {
        MinecraftForge.EVENT_BUS.post((Event)new LivingExtensionEvent.Load(this));
    }

    @Override
    public <T extends H> void registerHandler(LivingHandlerType<T> type, T handler) {
        if (this.handlers.put(type, handler) != null) {
            throw new IllegalArgumentException("Duplicate handler: " + type);
        }
    }

    @Override
    public <T extends LivingHandler> Optional<T> getHandler(LivingHandlerType<T> type) {
        return Optional.ofNullable((LivingHandler)this.handlers.get(type));
    }

    @Override
    public <T extends LivingHandler> T getHandlerOrThrow(LivingHandlerType<T> type) {
        LivingHandler handler = (LivingHandler)this.handlers.get(type);
        if (handler == null) {
            throw new IllegalStateException("Missing handler: " + type);
        }
        return (T)handler;
    }

    @Override
    public Optional<Action> getAction() {
        return Optional.ofNullable(this.action);
    }

    @Override
    public <T extends Action> boolean performAction(T action, boolean force, boolean sendUpdate) {
        if (MinecraftForge.EVENT_BUS.post(new LivingExtensionEvent.PerformAction<T>(this, action))) {
            return false;
        }
        if (this.isObservingAction() || action.getTarget().map(LivingExtension::isObservingAction).orElse(false).booleanValue()) {
            return false;
        }
        if (!action.start(false)) {
            return false;
        }
        this.cancelAction(true);
        this.action = action;
        this.setActionObserver(action.createPerformerObserver());
        action.getTarget().ifPresent(target -> target.setActionObserver(action.createTargetObserver()));
        if (sendUpdate) {
            PacketDistributor.PacketTarget target2 = this.getLevel().m_5776_() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::getEntity);
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            action.getType().encode(action, buf);
            NetworkChannel.PLAY.getSimpleChannel().send(target2, (Object)new PerformActionMessage(action.getType(), this.getEntity().m_142049_(), buf));
        }
        return true;
    }

    @Override
    public void cancelAction(boolean sendUpdate) {
        if (this.action == null) {
            return;
        }
        this.stopAction(Action.StopReason.CANCELLED);
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = this.getLevel().m_5776_() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new CancelActionMessage(this.getEntity().m_142049_()));
        }
    }

    @Override
    public void setActionObserver(ActionObserver actionObserver) {
        this.actionObserver = actionObserver;
    }

    @Override
    public Optional<ActionObserver> getActionObserver() {
        return Optional.ofNullable(this.actionObserver);
    }

    private void stopAction(Action.StopReason reason) {
        if (this.action != null) {
            this.action.stop(reason);
            this.action.getTarget().ifPresent(target -> target.setActionObserver(null));
            this.setActionObserver(null);
            this.action = null;
        }
    }

    @Override
    public void setMovementBlocked(boolean movementBlocked) {
        this.movementBlocked = movementBlocked;
    }

    @Override
    public boolean isMovementBlocked() {
        return this.movementBlocked;
    }

    @Override
    public boolean isMoving() {
        return this.moving;
    }

    @Override
    public void tick() {
        ItemStack heldStack = this.getMainHandItem();
        if (heldStack != this.lastHeldStack) {
            if (this.lastHeldStack != null) {
                this.lastHeldStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> gun.reset(this));
            }
            if ((this.lastHeldStack == null || !heldStack.m_150930_(this.lastHeldStack.m_41720_())) && heldStack.getCapability(Gun.CAPABILITY).isPresent()) {
                this.entity.m_5496_((SoundEvent)ModSoundEvents.GUN_EQUIP.get(), 0.25f, 1.0f);
            }
            this.lastHeldStack = heldStack;
        }
        this.movementBlocked = false;
        if (this.action != null && this.action.tick() && this.action != null) {
            this.stopAction(Action.StopReason.COMPLETED);
        }
        heldStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> gun.tick(this));
        this.updateClothing();
        this.updateHat();
        if (!this.entity.m_183503_().m_5776_()) {
            this.snapshots[this.entity.m_20194_().m_129921_() % 20] = new EntitySnapshot((Entity)this.entity, 1.0f);
        }
        this.moving = !this.entity.m_20182_().equals((Object)this.lastPos);
        this.lastPos = this.entity.m_20182_();
        this.handlers.forEach(this::tickHandler);
    }

    protected void tickHandler(LivingHandlerType<? extends H> type, H handler) {
        handler.tick();
        this.cachedVisibility = Visibility.VISIBLE;
        switch (handler.getVisibility()) {
            case INVISIBLE: {
                this.cachedVisibility = Visibility.INVISIBLE;
            }
            case PARTIALLY_VISIBLE: {
                if (this.cachedVisibility != Visibility.VISIBLE) break;
                this.cachedVisibility = Visibility.PARTIALLY_VISIBLE;
                break;
            }
        }
        if (handler.isMovementBlocked()) {
            this.movementBlocked = true;
        }
        if (handler.requiresSync()) {
            this.dirtyHandlers.put(type, handler);
        }
    }

    private void updateHat() {
        ItemStack headStack = this.itemHandler.getStackInSlot(ModEquipmentSlot.HAT.getIndex());
        Hat hat = (Hat)headStack.getCapability(Hat.CAPABILITY).orElse(null);
        if (headStack.m_41720_() == ModItems.SCUBA_MASK.get() && this.entity.m_204029_(FluidTags.f_13131_)) {
            this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 2, 0, false, false, false));
        } else if (hat != null && hat.hasNightVision()) {
            this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 2, 0, false, false, false));
        }
    }

    private void updateClothing() {
        ItemStack clothingStack = this.itemHandler.getStackInSlot(ModEquipmentSlot.CLOTHING.getIndex());
        Clothing clothing = (Clothing)clothingStack.getCapability(Clothing.CAPABILITY).orElse(null);
        if (clothingStack != this.lastClothingStack) {
            this.lastClothingStack.getCapability(Clothing.CAPABILITY).map(Clothing::getAttributeModifiers).ifPresent(arg_0 -> ((AttributeMap)this.entity.m_21204_()).m_22161_(arg_0));
            if (clothing != null) {
                this.entity.m_21204_().m_22178_(clothing.getAttributeModifiers());
            }
        }
        if (clothing != null && clothing.hasFireImmunity()) {
            if (this.entity.m_20094_() > 0) {
                this.entity.m_20095_();
            }
            this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 2, 0, false, false, false));
        }
        if (clothingStack.m_41720_() == ModItems.SCUBA_CLOTHING.get() && this.entity.m_204029_(FluidTags.f_13131_)) {
            this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 2, 0, false, false, false));
        }
        this.lastClothingStack = clothingStack;
    }

    @Override
    public float handleDamaged(DamageSource source, float amount) {
        Float damage = this.handlers.values().stream().reduce(Float.valueOf(amount), (result, extension) -> Float.valueOf(extension.handleDamaged(source, result.floatValue())), (u, t) -> t);
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            boolean usedMeleeWeapon;
            Player player = (Player)entity;
            if (((Boolean)CraftingDead.serverConfig.backstabEnabled.get()).booleanValue() && (usedMeleeWeapon = player.m_21120_(player.m_7655_()).m_41720_() instanceof MeleeWeaponItem) && !EntityUtil.canSee(this.getEntity(), (Entity)player, 90.0f)) {
                damage = Float.valueOf(damage.floatValue() * ((Double)CraftingDead.serverConfig.backstabBonusDamage.get()).floatValue());
            }
            if (((Boolean)CraftingDead.serverConfig.criticalHitEnable.get()).booleanValue() && (Double)CraftingDead.serverConfig.criticalHitChance.get() > (double)player.m_21187_().nextFloat()) {
                damage = Float.valueOf(damage.floatValue() * ((Double)CraftingDead.serverConfig.criticalHitBonusDamage.get()).floatValue());
            }
        }
        return damage.floatValue();
    }

    @Override
    public boolean handleHurt(DamageSource source, float amount) {
        return this.handlers.values().stream().anyMatch(e -> e.handleHurt(source, amount));
    }

    @Override
    public boolean handleKill(Entity target) {
        return this.handlers.values().stream().anyMatch(e -> e.handleKill(target));
    }

    @Override
    public boolean handleDeath(DamageSource cause) {
        return this.handlers.values().stream().anyMatch(e -> e.handleDeath(cause));
    }

    @Override
    public boolean handleDeathLoot(DamageSource cause, Collection<ItemEntity> drops, int lootingLevel) {
        if (this.handlers.values().stream().anyMatch(e -> e.handleDeathLoot(cause, drops, lootingLevel))) {
            return true;
        }
        if (!this.keepInventory()) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack itemStack = this.itemHandler.extractItem(i, Integer.MAX_VALUE, false);
                float dropChance = this.equipmentDropChances[i];
                if (itemStack.m_41619_() || !(Math.max(this.getRandom().nextFloat() - (float)lootingLevel * 0.01f, 0.0f) < dropChance)) continue;
                ItemEntity itemEntity = new ItemEntity(this.getLevel(), this.getEntity().m_20185_(), this.getEntity().m_20186_(), this.getEntity().m_20189_(), itemStack);
                itemEntity.m_32060_();
                drops.add(itemEntity);
            }
        }
        return false;
    }

    @Override
    public boolean handleBlockPlace(BlockSnapshot replacedBlock, BlockState placedBlock, BlockState placedAgainst) {
        return this.handlers.values().stream().anyMatch(e -> e.handleBlockPlace(replacedBlock, placedBlock, placedAgainst));
    }

    @Override
    public boolean handleMultiBlockPlace(List<BlockSnapshot> replacedBlocks, BlockState placedBlock, BlockState placedAgainst) {
        return this.handlers.values().stream().anyMatch(e -> e.handleMultiBlockPlace(replacedBlocks, placedBlock, placedAgainst));
    }

    protected boolean keepInventory() {
        return false;
    }

    @Override
    public Visibility getVisibility() {
        return this.cachedVisibility;
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public EntitySnapshot getSnapshot(int tick) {
        int currentTick = this.entity.m_20194_().m_129921_();
        if (tick == currentTick) {
            return new EntitySnapshot((Entity)this.entity, 1.0f);
        }
        if (tick < currentTick - 20) {
            return this.snapshots[0];
        }
        if (tick > currentTick) {
            throw new IllegalStateException("Tick bigger than current tick");
        }
        int snapshotIndex = tick % 20;
        EntitySnapshot snapshot = this.snapshots[snapshotIndex];
        if (snapshot == null) {
            throw new IndexOutOfBoundsException();
        }
        return snapshot;
    }

    @Override
    public boolean isCrouching() {
        return this.crouching;
    }

    @Override
    public void setCrouching(boolean crouching, boolean sendUpdate) {
        if (!this.entity.m_20096_()) {
            return;
        }
        this.crouching = crouching;
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = this.getLevel().m_5776_() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new CrouchMessage(this.getEntity().m_142049_(), crouching));
        }
    }

    @Override
    public E getEntity() {
        return this.entity;
    }

    @Override
    public float[] getEquipmentDropChances() {
        return Arrays.copyOf(this.equipmentDropChances, this.equipmentDropChances.length);
    }

    @Override
    public float getEquipmentDropChance(ModEquipmentSlot slot) {
        return this.equipmentDropChances[slot.getIndex()];
    }

    @Override
    public void setEquipmentDropChances(float[] newChances) throws IllegalArgumentException {
        if (newChances.length < this.equipmentDropChances.length) {
            throw new IllegalArgumentException(String.format("Missing drop chances. Expected %s but %s was provided.", this.equipmentDropChances.length, newChances.length));
        }
        this.equipmentDropChances = Arrays.copyOf(newChances, this.equipmentDropChances.length);
    }

    @Override
    public void setEquipmentDropChance(ModEquipmentSlot slot, float chance) {
        this.equipmentDropChances[slot.getIndex()] = chance;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        for (Map.Entry<LivingHandlerType<H>, H> entry : this.handlers.entrySet()) {
            CompoundTag extensionTag = ((LivingHandler)entry.getValue()).serializeNBT();
            if (extensionTag.m_128456_()) continue;
            tag.m_128365_(entry.getKey().toString(), (Tag)extensionTag);
        }
        ListTag dropChances = new ListTag();
        for (float dropChance : this.equipmentDropChances) {
            dropChances.add((Object)FloatTag.m_128566_((float)dropChance));
        }
        tag.m_128365_("dropChances", (Tag)dropChances);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        for (Map.Entry<LivingHandlerType<H>, H> entry : this.handlers.entrySet()) {
            CompoundTag extensionTag = tag.m_128469_(entry.getKey().toString());
            if (extensionTag.m_128456_()) continue;
            ((LivingHandler)entry.getValue()).deserializeNBT(extensionTag);
        }
        if (tag.m_128425_("dropChances", 9)) {
            ListTag dropChances = tag.m_128437_("dropChances", 5);
            for (int i = 0; i < dropChances.size(); ++i) {
                this.equipmentDropChances[i] = dropChances.m_128775_(i);
            }
        }
    }

    public int hashCode() {
        return this.entity.hashCode();
    }

    public boolean equals(Object obj) {
        LivingExtension extension;
        return super.equals(obj) || obj instanceof LivingExtension && (extension = (LivingExtension)obj).getEntity().equals(this.entity);
    }

    @Override
    public void encode(FriendlyByteBuf out, boolean writeAll) {
        if (writeAll) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                out.writeShort(i);
                out.m_130055_(this.itemHandler.getStackInSlot(i));
            }
        } else {
            this.dirtySlots.forEach(slot -> {
                out.writeShort(slot);
                out.m_130055_(this.itemHandler.getStackInSlot(slot));
            });
            this.dirtySlots.clear();
        }
        out.writeShort(255);
        Set<Map.Entry<LivingHandlerType<H>, H>> handlersToSend = writeAll ? this.handlers.entrySet() : this.dirtyHandlers.entrySet();
        out.m_130130_(handlersToSend.size());
        for (Map.Entry<LivingHandlerType<H>, H> entry : handlersToSend) {
            out.m_130085_(entry.getKey().id());
            FriendlyByteBuf handlerData = new FriendlyByteBuf(Unpooled.buffer());
            ((LivingHandler)entry.getValue()).encode(handlerData, writeAll);
            out.m_130130_(handlerData.readableBytes());
            out.writeBytes((ByteBuf)handlerData);
        }
        this.dirtyHandlers.clear();
    }

    @Override
    public void decode(FriendlyByteBuf in) {
        short slot;
        while ((slot = in.readShort()) != 255) {
            this.itemHandler.setStackInSlot((int)slot, in.m_130267_());
        }
        int handlersSize = in.m_130242_();
        for (int x = 0; x < handlersSize; ++x) {
            ResourceLocation id = in.m_130281_();
            int dataSize = in.m_130242_();
            LivingHandler handler = (LivingHandler)this.handlers.get(new LivingHandlerType(id));
            if (handler == null) {
                in.readerIndex(in.readerIndex() + dataSize);
                continue;
            }
            handler.decode(in);
        }
    }

    @Override
    public boolean requiresSync() {
        return !this.dirtySlots.isEmpty() || !this.dirtyHandlers.isEmpty();
    }
}

