/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.entity.grenade.Grenade;
import com.craftingdead.core.world.item.combatslot.CombatSlot;
import com.craftingdead.core.world.item.combatslot.CombatSlotProvider;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class GrenadeItem
extends Item {
    private final BiFunction<LivingEntity, Level, Grenade> grenadeEntitySupplier;
    private final float throwSpeed;
    private final BooleanSupplier enabled;
    private final boolean isSticky;

    public GrenadeItem(Properties properties) {
        super((Item.Properties)properties);
        this.grenadeEntitySupplier = properties.grenadeEntitySupplier;
        this.throwSpeed = properties.throwSpeed;
        this.enabled = properties.enabled;
        this.isSticky = properties.isSticky;
    }

    public void m_7373_(ItemStack item, @Nullable Level level, List<Component> lines, TooltipFlag tooltipFlag) {
        lines.add((Component)new TranslatableComponent("grenade.information").m_130940_(ChatFormatting.GRAY));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!this.enabled.getAsBoolean()) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        PlayerExtension<Player> extension = PlayerExtension.getOrThrow(player);
        if (extension.isHandcuffed()) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.4f / (player.m_21187_().nextFloat() * 0.4f + 0.8f));
        if (!level.m_5776_()) {
            Grenade grenadeEntity = this.grenadeEntitySupplier.apply((LivingEntity)player, level);
            float force = player.m_6144_() ? 0.4f : this.throwSpeed;
            grenadeEntity.m_6021_(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
            grenadeEntity.shootFromEntity((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, force, 1.0f);
            grenadeEntity.setSticky(this.isSticky);
            level.m_7967_((Entity)grenadeEntity);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundTag nbt) {
        return CapabilityUtil.provider(() -> CombatSlot.GRENADE, CombatSlotProvider.CAPABILITY);
    }

    public static class Properties
    extends Item.Properties {
        private BiFunction<LivingEntity, Level, Grenade> grenadeEntitySupplier;
        private float throwSpeed = 1.45f;
        private BooleanSupplier enabled = () -> true;
        private boolean isSticky;

        public Properties setGrenadeEntitySupplier(BiFunction<LivingEntity, Level, Grenade> grenadeEntitySupplier) {
            this.grenadeEntitySupplier = grenadeEntitySupplier;
            return this;
        }

        public Properties setThrowSpeed(float throwSpeed) {
            this.throwSpeed = throwSpeed;
            return this;
        }

        public Properties setEnabledSupplier(BooleanSupplier enabled) {
            this.enabled = enabled;
            return this;
        }

        public Properties setSticky(boolean isSticky) {
            this.isSticky = isSticky;
            return this;
        }
    }
}

