/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.RegisterGunColor;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.GunLike;
import com.craftingdead.core.world.item.gun.GunType;
import com.craftingdead.core.world.item.gun.TypedGun;
import com.craftingdead.core.world.item.gun.TypedGunClient;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.craftingdead.core.world.item.gun.magazine.Magazine;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;

@RegisterGunColor
public class GunItem
extends ProjectileWeaponItem
implements GunLike {
    private final Supplier<? extends GunType> type;

    protected GunItem(Supplier<? extends GunType> type) {
        super(new Item.Properties().m_41487_(1).m_41491_(ModItems.COMBAT_TAB));
        this.type = type;
    }

    @NotNull
    public Predicate<ItemStack> m_6437_() {
        return itemStack -> this.type.get().getAcceptedMagazines().stream().anyMatch(itemStack.m_41720_()::equals);
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, CompoundTag nbt) {
        return this.type.get().initCapabilities(itemStack, nbt);
    }

    protected <T extends TypedGun<?>> Function<T, TypedGunClient<? super T>> getClientFactory() {
        return this.type.get().getClientFactory();
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> lines, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, world, lines, tooltipFlag);
        itemStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> {
            MutableComponent ammoCount = new TextComponent(String.valueOf(gun.getAmmoProvider().getMagazine().map(Magazine::getSize).orElse(0))).m_130940_(ChatFormatting.RED);
            MutableComponent damageText = new TextComponent(String.valueOf(this.type.get().getDamage())).m_130940_(ChatFormatting.RED);
            MutableComponent headshotDamageText = new TextComponent(String.valueOf((int)((double)this.type.get().getDamage() * (Double)CraftingDead.serverConfig.headshotBonusDamage.get()))).m_130940_(ChatFormatting.RED);
            MutableComponent accuracyText = new TextComponent((int)((double)this.type.get().getAccuracyPct() * 100.0) + "%").m_130940_(ChatFormatting.RED);
            MutableComponent rpmText = new TextComponent(String.valueOf(this.type.get().getFireRateRPM())).m_130940_(ChatFormatting.RED);
            MutableComponent rangeText = new TextComponent(this.type.get().getRange() + " blocks").m_130940_(ChatFormatting.RED);
            lines.add((Component)new TranslatableComponent("gun.ammo_amount").m_130940_(ChatFormatting.GRAY).m_7220_((Component)ammoCount));
            lines.add((Component)new TranslatableComponent("gun.damage").m_130940_(ChatFormatting.GRAY).m_7220_((Component)damageText));
            lines.add((Component)new TranslatableComponent("gun.headshot_damage").m_130940_(ChatFormatting.GRAY).m_7220_((Component)headshotDamageText));
            if (this.type.get().getRoundsPerShot() > 1) {
                MutableComponent pelletsText = new TextComponent(String.valueOf(this.type.get().getRoundsPerShot())).m_130940_(ChatFormatting.RED);
                lines.add((Component)new TranslatableComponent("gun.pellets_shot").m_130940_(ChatFormatting.GRAY).m_7220_((Component)pelletsText));
            }
            for (Attachment attachment : gun.getAttachments()) {
                MutableComponent attachmentName = attachment.getDescription().m_6879_().m_130940_(ChatFormatting.RED);
                lines.add((Component)new TranslatableComponent("gun.attachment").m_130940_(ChatFormatting.GRAY).m_7220_((Component)attachmentName));
            }
            lines.add((Component)new TranslatableComponent("gun.rpm").m_130940_(ChatFormatting.GRAY).m_7220_((Component)rpmText));
            lines.add((Component)new TranslatableComponent("gun.accuracy").m_130940_(ChatFormatting.GRAY).m_7220_((Component)accuracyText));
            lines.add((Component)new TranslatableComponent("gun.range").m_130940_(ChatFormatting.GRAY).m_7220_((Component)rangeText));
        });
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44990_ || enchantment == Enchantments.f_44988_ || enchantment == Enchantments.f_44986_ || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int m_6473_() {
        return 1;
    }

    public int m_6615_() {
        return 0;
    }

    @Override
    public GunType asGun() {
        return this.type.get();
    }
}

