/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class ItemUtils {
    public static void saveInventory(CompoundTag compound, String name, Container inventory) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i).m_41619_()) continue;
            CompoundTag slot = new CompoundTag();
            slot.m_128405_("slot", i);
            inventory.m_8020_(i).m_41739_(slot);
            tagList.add((Object)slot);
        }
        compound.m_128365_(name, (Tag)tagList);
    }

    public static void saveInventory(CompoundTag compound, String name, NonNullList<ItemStack> inventory) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < inventory.size(); ++i) {
            if (((ItemStack)inventory.get(i)).m_41619_()) continue;
            CompoundTag slot = new CompoundTag();
            slot.m_128405_("slot", i);
            ((ItemStack)inventory.get(i)).m_41739_(slot);
            tagList.add((Object)slot);
        }
        compound.m_128365_(name, (Tag)tagList);
    }

    public static void saveItemList(CompoundTag compound, String name, NonNullList<ItemStack> list) {
        ItemUtils.saveItemList(compound, name, list, true);
    }

    public static void saveItemList(CompoundTag compound, String name, NonNullList<ItemStack> list, boolean includeEmpty) {
        ListTag itemList = new ListTag();
        for (ItemStack stack : list) {
            if (!includeEmpty && stack.m_41619_()) continue;
            itemList.add((Object)stack.m_41739_(new CompoundTag()));
        }
        compound.m_128365_(name, (Tag)itemList);
    }

    public static void readInventory(CompoundTag compound, String name, Container inv) {
        if (!compound.m_128441_(name)) {
            return;
        }
        ListTag tagList = compound.m_128437_(name, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag slot = tagList.m_128728_(i);
            int j = slot.m_128451_("slot");
            if (j < 0 || j >= inv.m_6643_()) continue;
            inv.m_6836_(j, ItemStack.m_41712_((CompoundTag)slot));
        }
    }

    public static void readInventory(CompoundTag compound, String name, NonNullList<ItemStack> inventory) {
        if (!compound.m_128441_(name)) {
            return;
        }
        ListTag tagList = compound.m_128437_(name, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag slot = tagList.m_128728_(i);
            int j = slot.m_128451_("slot");
            if (j < 0 || j >= inventory.size()) continue;
            inventory.set(j, (Object)ItemStack.m_41712_((CompoundTag)slot));
        }
    }

    public static NonNullList<ItemStack> readItemList(CompoundTag compound, String name, boolean includeEmpty) {
        NonNullList items = NonNullList.m_122779_();
        if (!compound.m_128441_(name)) {
            return items;
        }
        ListTag itemList = compound.m_128437_(name, 10);
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack item = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i));
            if (!includeEmpty) {
                if (item.m_41619_()) continue;
                items.add((Object)item);
                continue;
            }
            items.add((Object)item);
        }
        return items;
    }

    public static NonNullList<ItemStack> readItemList(CompoundTag compound, String name) {
        return ItemUtils.readItemList(compound, name, true);
    }

    public static void readItemList(CompoundTag compound, String name, NonNullList<ItemStack> list) {
        if (!compound.m_128441_(name)) {
            return;
        }
        ListTag itemList = compound.m_128437_(name, 10);
        for (int i = 0; i < itemList.size() && i < list.size(); ++i) {
            list.set(i, (Object)ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i)));
        }
    }
}

