/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.world.item.gun.magazine.Magazine;
import com.craftingdead.core.world.item.gun.magazine.MagazineImpl;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public class MagazineItem
extends Item {
    private final float armorPenetration;
    private final int size;

    public MagazineItem(Properties properties) {
        super((Item.Properties)properties);
        this.size = properties.size;
        this.armorPenetration = properties.armorPenetration;
    }

    public float getArmorPenetration() {
        return this.armorPenetration;
    }

    public int getSize() {
        return this.size;
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundTag nbt) {
        return CapabilityUtil.serializableProvider(() -> new MagazineImpl(this), Magazine.CAPABILITY);
    }

    public boolean m_6832_(ItemStack itemStack, ItemStack materialStack) {
        return materialStack.m_204117_(Tags.Items.GUNPOWDER) || super.m_6832_(itemStack, materialStack);
    }

    public int getMaxDamage(ItemStack itemStack) {
        return this.size;
    }

    public int getDamage(ItemStack itemStack) {
        return this.size - itemStack.getCapability(Magazine.CAPABILITY).map(Magazine::getSize).orElse(this.size);
    }

    public void setDamage(ItemStack itemStack, int damage) {
        itemStack.getCapability(Magazine.CAPABILITY).ifPresent(magazine -> magazine.setSize(Math.max(0, this.size - damage)));
    }

    public boolean m_41465_() {
        return true;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, lines, tooltipFlag);
        if (this.getSize() > 1) {
            int currentAmount = stack.getCapability(Magazine.CAPABILITY).map(Magazine::getSize).orElse(0);
            MutableComponent amountText = new TextComponent(currentAmount + "/" + this.getSize()).m_130940_(ChatFormatting.RED);
            lines.add((Component)new TranslatableComponent("magazine.amount").m_130940_(ChatFormatting.GRAY).m_7220_((Component)amountText));
        }
        if (this.armorPenetration > 0.0f) {
            lines.add((Component)new TranslatableComponent("magazine.armor_penetration").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.format("%.0f%%", Float.valueOf(this.armorPenetration))).m_130940_(ChatFormatting.RED)));
        }
    }

    public CompoundTag getShareTag(ItemStack itemStack) {
        CompoundTag magazineNbt;
        CompoundTag nbt = super.getShareTag(itemStack);
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        if ((magazineNbt = (CompoundTag)itemStack.getCapability(Magazine.CAPABILITY).map(INBTSerializable::serializeNBT).orElse(null)) != null && !magazineNbt.m_128456_()) {
            nbt.m_128365_("magazine", (Tag)magazineNbt);
        }
        return nbt;
    }

    public void readShareTag(ItemStack itemStack, @Nullable CompoundTag nbt) {
        super.readShareTag(itemStack, nbt);
        if (nbt != null && nbt.m_128425_("magazine", 10)) {
            itemStack.getCapability(Magazine.CAPABILITY).ifPresent(magazine -> magazine.deserializeNBT((Tag)nbt.m_128469_("magazine")));
        }
    }

    public static class Properties
    extends Item.Properties {
        private float armorPenetration;
        private int size;

        public Properties setArmorPenetration(float armorPenetration) {
            this.armorPenetration = armorPenetration;
            return this;
        }

        public Properties setSize(int size) {
            this.size = size;
            return this;
        }
    }
}

