/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.world.inventory.GenericMenu;
import com.craftingdead.core.world.inventory.ModEquipmentSlot;
import com.craftingdead.core.world.inventory.storage.ItemStackHandlerStorage;
import com.craftingdead.core.world.inventory.storage.Storage;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.Nullable;

public class StorageItem
extends Item {
    public static final int MAX_ROWS_TO_SHOW = 6;
    public static final NonNullSupplier<Storage> VEST = () -> new ItemStackHandlerStorage(18, ModEquipmentSlot.VEST, GenericMenu::createVest);
    public static final NonNullSupplier<Storage> SMALL_BACKPACK = () -> new ItemStackHandlerStorage(18, ModEquipmentSlot.BACKPACK, GenericMenu::createSmallBackpack);
    public static final NonNullSupplier<Storage> MEDIUM_BACKPACK = () -> new ItemStackHandlerStorage(36, ModEquipmentSlot.BACKPACK, GenericMenu::createMediumBackpack);
    public static final NonNullSupplier<Storage> LARGE_BACKPACK = () -> new ItemStackHandlerStorage(54, ModEquipmentSlot.BACKPACK, GenericMenu::createLargeBackpack);
    public static final NonNullSupplier<Storage> GUN_BAG = () -> new ItemStackHandlerStorage(36, ModEquipmentSlot.BACKPACK, GenericMenu::createGunBag);
    private final NonNullSupplier<Storage> storageContainer;

    public StorageItem(NonNullSupplier<Storage> storageContainer, Item.Properties properties) {
        super(properties);
        this.storageContainer = storageContainer;
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundTag nbt) {
        return CapabilityUtil.serializableProvider(this.storageContainer, Storage.CAPABILITY, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    public void m_7373_(ItemStack backpackStack, Level world, List<Component> lines, TooltipFlag tooltipFlag) {
        super.m_7373_(backpackStack, world, lines, tooltipFlag);
        backpackStack.getCapability(Storage.CAPABILITY).ifPresent(storage -> {
            if (!storage.isEmpty()) {
                lines.add((Component)new TextComponent(" "));
                lines.add((Component)new TranslatableComponent("storage_item.contents").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
                int itemsBeyondLimit = 0;
                int itemsDisplayed = 0;
                for (int i = 0; i < storage.getSlots(); ++i) {
                    ItemStack stack = storage.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    if (itemsDisplayed++ >= 6) {
                        ++itemsBeyondLimit;
                        continue;
                    }
                    MutableComponent amountText = new TextComponent(stack.m_41613_() + "x ").m_130940_(ChatFormatting.DARK_GRAY);
                    MutableComponent itemText = stack.m_41786_().m_6879_().m_130940_(ChatFormatting.GRAY);
                    lines.add((Component)amountText.m_7220_((Component)itemText));
                }
                if (itemsBeyondLimit > 0) {
                    lines.add((Component)new TextComponent(". . . +" + itemsBeyondLimit).m_130940_(ChatFormatting.RED));
                }
            }
        });
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag storageTag;
        CompoundTag shareTag = stack.m_41783_();
        if (shareTag == null) {
            shareTag = new CompoundTag();
        }
        if ((storageTag = (CompoundTag)stack.getCapability(Storage.CAPABILITY).map(INBTSerializable::serializeNBT).orElse(null)) != null && !storageTag.m_128456_()) {
            shareTag.m_128365_("storage", (Tag)storageTag);
        }
        return shareTag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag tag) {
        if (tag != null && tag.m_128425_("storage", 10)) {
            stack.getCapability(Storage.CAPABILITY).ifPresent(gun -> gun.deserializeNBT((Tag)tag.m_128469_("storage")));
        }
        super.readShareTag(stack, tag);
    }
}

