/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.client.ClientDist;
import com.craftingdead.core.client.animation.Animation;
import com.craftingdead.core.client.animation.AnimationController;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.ValidatePendingHitMessage;
import com.craftingdead.core.sounds.ModSoundEvents;
import com.craftingdead.core.world.entity.extension.EntitySnapshot;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.gun.AbstractGun;
import com.craftingdead.core.world.item.gun.GunAnimationEvent;
import com.craftingdead.core.world.item.gun.GunClient;
import com.craftingdead.core.world.item.gun.PendingHit;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGunClient<T extends AbstractGun>
implements GunClient {
    private static final int MUZZLE_FLASH_DURATION_TICKS = 2;
    protected final ClientDist client = CraftingDead.getInstance().getClientDist();
    protected final Minecraft minecraft = Minecraft.m_91087_();
    protected final T gun;
    private final AnimationController animationController = new AnimationController();
    private int lastShotCount;
    private int remainingFlashTicks;
    private long secondaryActionSoundStartTimeMs;
    private final Multimap<Integer, PendingHit> livingHitValidationBuffer = Multimaps.synchronizedListMultimap((ListMultimap)Multimaps.newListMultimap((Map)new Int2ObjectLinkedOpenHashMap(), ObjectArrayList::new));
    private byte hitValidationTicks = 0;
    @Nullable
    private Animation currentShootAnimation;

    public AbstractGunClient(T gun) {
        this.gun = gun;
    }

    public float getPartialTick() {
        return this.minecraft.m_91296_();
    }

    protected abstract Optional<SoundEvent> getSecondaryActionSound();

    protected abstract long getSecondaryActionSoundRepeatDelayMs();

    public void handleTick(LivingExtension<?, ?> living) {
        if (living.getEntity() instanceof LocalPlayer && this.livingHitValidationBuffer.size() > 0) {
            byte by = this.hitValidationTicks;
            this.hitValidationTicks = (byte)(by + 1);
            if (by >= 3) {
                this.hitValidationTicks = 0;
                NetworkChannel.PLAY.getSimpleChannel().sendToServer((Object)new ValidatePendingHitMessage(new HashMap<Integer, Collection<PendingHit>>(this.livingHitValidationBuffer.asMap())));
                this.livingHitValidationBuffer.clear();
            }
        }
        this.getSecondaryActionSound().ifPresent(sound -> {
            long delta = Util.m_137550_() - this.secondaryActionSoundStartTimeMs + 50L;
            long repeatDelay = this.getSecondaryActionSoundRepeatDelayMs();
            if (((AbstractGun)this.gun).isPerformingSecondaryAction() && repeatDelay > 0L && delta >= repeatDelay) {
                this.secondaryActionSoundStartTimeMs = Util.m_137550_();
                living.getEntity().m_5496_(sound, 1.0f, 1.0f);
            }
        });
        if (!((AbstractGun)this.gun).isTriggerPressed()) {
            this.lastShotCount = 0;
        }
        if (this.remainingFlashTicks > 0) {
            --this.remainingFlashTicks;
        }
        this.animationController.tick();
    }

    protected abstract float getRecoil();

    protected abstract SoundEvent getShootSound();

    protected abstract Optional<SoundEvent> getDistantShootSound();

    protected abstract Optional<SoundEvent> getSilencedShootSound();

    protected boolean canFlash(LivingExtension<?, ?> living) {
        return this.minecraft.f_91066_.m_92176_() == CameraType.FIRST_PERSON && ((AbstractGun)this.gun).getShotCount() != this.lastShotCount && ((AbstractGun)this.gun).getShotCount() > 0;
    }

    public void handleShoot(LivingExtension<?, ?> living) {
        SoundEvent shootSound;
        double sqrDistance;
        Object entity = living.getEntity();
        if (this.canFlash(living)) {
            this.remainingFlashTicks = 2;
        }
        this.lastShotCount = ((AbstractGun)this.gun).getShotCount();
        if (this.currentShootAnimation != null) {
            this.currentShootAnimation.remove();
        }
        this.currentShootAnimation = this.getAnimation(GunAnimationEvent.SHOOT);
        this.animationController.addAnimation(this.currentShootAnimation);
        if (entity == this.minecraft.m_91288_()) {
            this.client.getCameraManager().randomRecoil(this.getRecoil(), true);
        }
        boolean farAway = (sqrDistance = this.minecraft.f_91063_.m_109153_().m_90583_().m_82531_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())) > 1600.0;
        SoundEvent defaultShootSound = this.getShootSound();
        boolean amplifyDistantSound = this.getDistantShootSound().isPresent();
        if (((AbstractGun)this.gun).getAttachments().stream().anyMatch(Attachment::isSoundSuppressor)) {
            shootSound = farAway ? null : this.getSilencedShootSound().orElse(defaultShootSound);
        } else {
            SoundEvent soundEvent = shootSound = farAway ? this.getDistantShootSound().orElse(defaultShootSound) : defaultShootSound;
        }
        if (!entity.m_20067_() && shootSound != null) {
            this.minecraft.execute(() -> entity.f_19853_.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), shootSound, entity.m_5720_(), farAway && amplifyDistantSound ? 8.0f : 1.0f, 1.0f, true));
        }
    }

    public void handleHitEntityPre(LivingExtension<?, ?> living, Entity hitEntity, Vec3 hitPos, long randomSeed) {
        if (living.getEntity() instanceof LocalPlayer && hitEntity instanceof LivingEntity) {
            this.livingHitValidationBuffer.put((Object)hitEntity.m_142049_(), (Object)new PendingHit((byte)(3 - this.hitValidationTicks), new EntitySnapshot((Entity)living.getEntity(), this.minecraft.m_91296_()), new EntitySnapshot(hitEntity, this.minecraft.m_91296_()), randomSeed, ((AbstractGun)this.gun).getShotCount()));
        }
    }

    public void handleHitEntityPost(LivingExtension<?, ?> living, Entity hitEntity, Vec3 hitPos, boolean playSound, boolean headshot) {
        int i;
        int particleCount;
        if (!(hitEntity instanceof LivingEntity)) {
            return;
        }
        Level level = hitEntity.f_19853_;
        if (headshot) {
            particleCount = 12;
            for (i = 0; i < 12; ++i) {
                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50453_.m_49966_()), hitPos.m_7096_(), hitPos.m_7098_(), hitPos.m_7094_(), 0.0, 0.0, 0.0);
            }
        }
        level.m_5594_(living.getEntity() instanceof Player ? (Player)living.getEntity() : null, hitEntity.m_142538_(), (SoundEvent)ModSoundEvents.BULLET_IMPACT_FLESH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (hitEntity == this.minecraft.m_91288_()) {
            this.client.getCameraManager().randomRecoil(1.5f, false);
        }
        particleCount = 12;
        for (i = 0; i < 12; ++i) {
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50330_.m_49966_()), hitPos.m_7096_(), hitPos.m_7098_(), hitPos.m_7094_(), 0.0, 0.0, 0.0);
        }
    }

    public void handleHitBlock(LivingExtension<?, ?> living, BlockHitResult result, BlockState blockState, boolean playSound) {
        Object entity = living.getEntity();
        Level level = ((Entity)entity).f_19853_;
        Vec3 location = result.m_82450_();
        if (playSound) {
            SoundEvent hitSound = (SoundEvent)ModSoundEvents.BULLET_IMPACT_DIRT.get();
            Material blockMaterial = blockState.m_60767_();
            if (blockMaterial == Material.f_76320_) {
                hitSound = (SoundEvent)ModSoundEvents.BULLET_IMPACT_WOOD.get();
            } else if (blockMaterial == Material.f_76278_) {
                hitSound = (SoundEvent)ModSoundEvents.BULLET_IMPACT_STONE.get();
            } else if (blockMaterial == Material.f_76279_) {
                hitSound = Math.random() > 0.5 ? (SoundEvent)ModSoundEvents.BULLET_IMPACT_METAL.get() : (SoundEvent)ModSoundEvents.BULLET_IMPACT_METAL2.get();
            } else if (blockMaterial == Material.f_76275_) {
                hitSound = (SoundEvent)ModSoundEvents.BULLET_IMPACT_GLASS.get();
            }
            level.m_5594_(entity instanceof Player ? (Player)entity : null, result.m_82425_(), hitSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        int particleCount = 12;
        for (int i = 0; i < 12; ++i) {
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), location.m_7096_(), location.m_7098_(), location.m_7094_(), 0.0, 0.0, 0.0);
        }
    }

    public void handleToggleSecondaryAction(LivingExtension<?, ?> living) {
        this.getSecondaryActionSound().ifPresent(sound -> {
            if (((AbstractGun)this.gun).isPerformingSecondaryAction()) {
                this.secondaryActionSoundStartTimeMs = Util.m_137550_();
                living.getEntity().m_5496_(sound, 1.0f, 1.0f);
            } else {
                this.minecraft.m_91106_().m_120386_(sound.getRegistryName(), SoundSource.PLAYERS);
            }
        });
    }

    @Override
    public boolean isFlashing() {
        return this.remainingFlashTicks > 0;
    }

    @Override
    public AnimationController getAnimationController() {
        return this.animationController;
    }
}

