/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun;

import com.craftingdead.core.network.Synched;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.inventory.GunCraftSlotType;
import com.craftingdead.core.world.item.combatslot.CombatSlotProvider;
import com.craftingdead.core.world.item.gun.FireMode;
import com.craftingdead.core.world.item.gun.GunClient;
import com.craftingdead.core.world.item.gun.PendingHit;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.craftingdead.core.world.item.gun.skin.Skin;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Gun
extends CombatSlotProvider,
Synched {
    public static final Capability<Gun> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Gun>(){});

    public void tick(LivingExtension<?, ?> var1);

    public void reset(LivingExtension<?, ?> var1);

    public void setTriggerPressed(LivingExtension<?, ?> var1, boolean var2, boolean var3);

    public boolean isTriggerPressed();

    public void validatePendingHit(PlayerExtension<ServerPlayer> var1, LivingExtension<?, ?> var2, PendingHit var3);

    public float getAccuracy(LivingExtension<?, ?> var1, Random var2);

    public Set<Attachment> getAttachments();

    default public float getAttachmentMultiplier(Attachment.MultiplierType multiplierType) {
        return this.getAttachments().stream().map(attachment -> Float.valueOf(attachment.getMultiplier(multiplierType))).reduce(Float.valueOf(1.0f), (x, y) -> Float.valueOf(x.floatValue() * y.floatValue())).floatValue();
    }

    public void setAttachments(Set<Attachment> var1);

    default public boolean hasIronSight() {
        for (Attachment attachmentItem : this.getAttachments()) {
            if (attachmentItem.getInventorySlot() != GunCraftSlotType.OVERBARREL_ATTACHMENT) continue;
            return false;
        }
        return true;
    }

    public ItemStack getPaintStack();

    public void setPaintStack(ItemStack var1);

    @Nullable
    public Skin getSkin();

    public void setSkin(@Nullable Holder<Skin> var1);

    default public Optional<ResourceLocation> getSkinName() {
        return this.getPaintStack().m_41619_() ? Optional.empty() : Optional.of(this.getPaintStack().m_41720_().getRegistryName());
    }

    public boolean isAcceptedAttachment(ItemStack var1);

    public FireMode getFireMode();

    public void setFireMode(LivingExtension<?, ?> var1, FireMode var2, boolean var3);

    public void toggleFireMode(LivingExtension<?, ?> var1, boolean var2);

    public boolean isPerformingSecondaryAction();

    public void setPerformingSecondaryAction(LivingExtension<?, ?> var1, boolean var2, boolean var3);

    public SecondaryActionTrigger getSecondaryActionTrigger();

    public Optional<SoundEvent> getReloadSound();

    public int getReloadDurationTicks();

    public GunClient getClient();

    public AmmoProvider getAmmoProvider();

    public void setAmmoProvider(AmmoProvider var1);

    public Set<? extends Item> getAcceptedMagazines();

    public ItemStack getDefaultMagazineStack();

    public ItemStack getItemStack();

    public static enum SecondaryActionTrigger implements StringRepresentable
    {
        HOLD("hold"),
        TOGGLE("toggle");

        private static final Map<String, SecondaryActionTrigger> BY_NAME;
        public static final Codec<SecondaryActionTrigger> CODEC;
        private final String name;

        private SecondaryActionTrigger(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public static SecondaryActionTrigger byName(String name) {
            return BY_NAME.get(name);
        }

        static {
            BY_NAME = Arrays.stream(SecondaryActionTrigger.values()).collect(Collectors.toMap(SecondaryActionTrigger::m_7912_, Function.identity()));
            CODEC = StringRepresentable.m_14350_(SecondaryActionTrigger::values, SecondaryActionTrigger::byName);
        }
    }
}

