/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun.aimable;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.gun.TypedGun;
import com.craftingdead.core.world.item.gun.aimable.AimableGunClient;
import com.craftingdead.core.world.item.gun.aimable.AimableGunType;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.craftingdead.core.world.item.scope.Scope;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class AimableGun
extends TypedGun<AimableGunType>
implements Scope {
    private boolean waitingForBoltAction;

    public static AimableGun create(Function<AimableGun, AimableGunClient> clientFactory, ItemStack itemStack, AimableGunType type) {
        AimableGun gun = new AimableGun(clientFactory, itemStack, type);
        gun.initialize();
        return gun;
    }

    private AimableGun(Function<AimableGun, AimableGunClient> clientFactory, ItemStack itemStack, AimableGunType type) {
        super(clientFactory, itemStack, type);
    }

    @Override
    public void reset(LivingExtension<?, ?> living) {
        super.reset(living);
        this.waitingForBoltAction = false;
    }

    @Override
    public void tick(LivingExtension<?, ?> living) {
        long timeDelta = Util.m_137550_() - this.lastShotMs;
        if (timeDelta >= (long)((AimableGunType)((Object)this.getType())).getFireDelayMs() && this.waitingForBoltAction) {
            this.waitingForBoltAction = false;
            if (!this.isPerformingSecondaryAction()) {
                this.setPerformingSecondaryAction(living, true, false);
            }
        }
        super.tick(living);
    }

    @Override
    protected void processShot(LivingExtension<?, ?> living) {
        super.processShot(living);
        if (this.isPerformingSecondaryAction() && ((AimableGunType)((Object)this.getType())).hasBoltAction()) {
            this.setPerformingSecondaryAction(living, false, false);
            this.waitingForBoltAction = true;
        }
    }

    @Override
    public boolean isScoping(LivingExtension<?, ?> living) {
        return this.isPerformingSecondaryAction();
    }

    @Override
    public float getZoomMultiplier(LivingExtension<?, ?> living) {
        return this.hasIronSight() ? 2.0f : this.getAttachmentMultiplier(Attachment.MultiplierType.ZOOM) + ((Double)CraftingDead.serverConfig.scopeZoomMultiplier.get()).floatValue();
    }

    @Override
    public float getAccuracy(LivingExtension<?, ?> living, Random random) {
        return super.getAccuracy(living, random) * (this.isScoping(living) ? ((Double)CraftingDead.serverConfig.scopeZoomAccuracyMultiplier.get()).floatValue() : 1.0f);
    }

    @Override
    public Optional<ResourceLocation> getOverlayTexture(LivingExtension<?, ?> living) {
        for (Attachment attachment : this.getAttachments()) {
            if (!attachment.isScope()) continue;
            return Optional.of(new ResourceLocation(attachment.getRegistryName().m_135827_(), "textures/scope/" + attachment.getRegistryName().m_135815_() + ".png"));
        }
        return Optional.empty();
    }

    @Override
    public void setPerformingSecondaryAction(LivingExtension<?, ?> living, boolean performingRightMouseAction, boolean sendUpdate) {
        if (!this.waitingForBoltAction) {
            super.setPerformingSecondaryAction(living, performingRightMouseAction, sendUpdate);
        }
    }

    @Override
    public int getOverlayTextureWidth() {
        return 2048;
    }

    @Override
    public int getOverlayTextureHeight() {
        return 512;
    }
}

