/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun.aimable;

import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.world.item.combatslot.CombatSlotProvider;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.GunType;
import com.craftingdead.core.world.item.gun.GunTypeFactories;
import com.craftingdead.core.world.item.gun.GunTypeFactory;
import com.craftingdead.core.world.item.gun.aimable.AimAttributes;
import com.craftingdead.core.world.item.gun.aimable.AimableGun;
import com.craftingdead.core.world.item.gun.aimable.AimableGunClient;
import com.craftingdead.core.world.item.scope.Scope;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class AimableGunType
extends GunType {
    public static final Codec<AimableGunType> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GunType.GeneralAttributes.CODEC.fieldOf("general_attributes").forGetter(GunType::getAttributes), (App)GunType.Sounds.CODEC.fieldOf("sounds").forGetter(GunType::getSounds), (App)AimAttributes.CODEC.optionalFieldOf("aim_attributes", (Object)new AimAttributes(false)).forGetter(AimableGunType::getAimAttributes)).apply((Applicative)instance, AimableGunType::new));
    private final AimAttributes aimAttributes;

    private AimableGunType(GunType.GeneralAttributes attributes, GunType.Sounds sounds, AimAttributes aimAttributes) {
        super(attributes, sounds);
        this.aimAttributes = aimAttributes;
    }

    protected AimableGunType(Builder builder) {
        super(builder);
        this.aimAttributes = new AimAttributes(builder.boltAction);
    }

    public AimAttributes getAimAttributes() {
        return this.aimAttributes;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack itemStack, CompoundTag nbt) {
        return CapabilityUtil.serializableProvider(() -> AimableGun.create(AimableGunClient::new, itemStack, this), Gun.CAPABILITY, CombatSlotProvider.CAPABILITY, Scope.CAPABILITY);
    }

    public boolean hasBoltAction() {
        return this.aimAttributes.boltAction();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public GunTypeFactory getFactory() {
        return (GunTypeFactory)((Object)GunTypeFactories.AIMABLE.get());
    }

    public static class Builder
    extends GunType.Builder<Builder> {
        private boolean boltAction = false;

        private Builder() {
            super(AimableGunType::new);
        }

        public Builder setBoltAction(boolean boltAction) {
            this.boltAction = boltAction;
            return this;
        }
    }
}

