/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun.ammoprovider;

import com.craftingdead.core.network.Synched;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.ActionTypes;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProviderType;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProviderTypes;
import com.craftingdead.core.world.item.gun.magazine.Magazine;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class RefillableAmmoProvider
implements AmmoProvider {
    private ItemStack magazineStack;
    private int reserveSize;
    private boolean infiniteAmmo;
    private boolean reserveSizeChanged;

    public RefillableAmmoProvider() {
        this(ItemStack.f_41583_, 0, false);
    }

    public RefillableAmmoProvider(ItemStack magazineStack, int reserveMagazineCount, boolean infiniteAmmo) {
        this.magazineStack = magazineStack;
        this.reserveSize = this.getMagazine().map(Magazine::getMaxSize).orElse(0) * reserveMagazineCount;
        this.infiniteAmmo = infiniteAmmo;
    }

    public boolean hasInfiniteAmmo() {
        return this.infiniteAmmo;
    }

    public void refillMagazine() {
        Magazine magazine = this.getExpectedMagazine();
        this.moveAmmoToReserve(magazine.getSize());
        this.moveAmmoToMagazine(this.infiniteAmmo ? magazine.getMaxSize() : Math.min(magazine.getMaxSize(), this.reserveSize));
    }

    public boolean moveAmmoToMagazine(int amount) {
        if (!this.infiniteAmmo && this.reserveSize < amount) {
            return false;
        }
        Magazine magazine = this.getExpectedMagazine();
        int ammoToLoad = Math.min(magazine.getMaxSize(), amount);
        magazine.setSize(ammoToLoad);
        if (!this.infiniteAmmo) {
            this.reserveSize -= ammoToLoad;
            this.reserveSizeChanged = true;
        }
        return true;
    }

    public boolean moveAmmoToReserve(int amount) {
        Magazine magazine = this.getExpectedMagazine();
        int currentSize = magazine.getSize();
        if (currentSize < amount) {
            return false;
        }
        if (!this.infiniteAmmo) {
            this.reserveSize += amount;
            this.reserveSizeChanged = true;
        }
        magazine.setSize(currentSize - amount);
        return true;
    }

    @Override
    public void reload(LivingExtension<?, ?> living) {
        living.performAction((Action)((ActionType)ActionTypes.REFILLABLE_RELOAD.get()).decode(living, null), true);
    }

    @Override
    public void unload(LivingExtension<?, ?> living) {
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("magazineStack", (Tag)this.magazineStack.serializeNBT());
        nbt.m_128405_("reserveSize", this.reserveSize);
        nbt.m_128379_("infiniteAmmo", this.infiniteAmmo);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_("magazineStack", 10)) {
            this.magazineStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("magazineStack"));
        }
        this.reserveSize = nbt.m_128451_("reserveSize");
        this.infiniteAmmo = nbt.m_128471_("infiniteAmmo");
    }

    @Override
    public void encode(FriendlyByteBuf out, boolean writeAll) {
        if (writeAll) {
            out.writeBoolean(true);
            out.m_130055_(this.magazineStack);
            out.writeBoolean(this.infiniteAmmo);
        } else {
            out.writeBoolean(false);
        }
        this.getExpectedMagazine().encode(out, writeAll);
        out.m_130130_(this.reserveSize);
        this.reserveSizeChanged = false;
    }

    @Override
    public void decode(FriendlyByteBuf in) {
        if (in.readBoolean()) {
            this.magazineStack = in.m_130267_();
            this.infiniteAmmo = in.readBoolean();
        }
        this.getExpectedMagazine().decode(in);
        this.reserveSize = in.m_130242_();
    }

    @Override
    public boolean requiresSync() {
        return this.reserveSizeChanged || this.getMagazine().map(Synched::requiresSync).orElse(false) != false;
    }

    @Override
    public int getReserveSize() {
        return this.reserveSize;
    }

    @Override
    public ItemStack getMagazineStack() {
        return this.magazineStack;
    }

    @Override
    public AmmoProviderType getType() {
        return (AmmoProviderType)((Object)AmmoProviderTypes.REFILLABLE.get());
    }
}

