/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.scope;

import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.item.scope.Scope;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class SimpleScope
implements Scope {
    private final float zoomMultiplier;
    private final Optional<ResourceLocation> overlayTexture;
    private final int overlayTextureWidth;
    private final int overlayTextureHeight;
    private final ItemStack itemStack;

    public SimpleScope(ItemStack itemStack) {
        this(1.0f, null, 0, 0, itemStack);
    }

    public SimpleScope(float zoomMultiplier, ResourceLocation overlayTexture, int overlayTextureWidth, int overlayTextureHeight, ItemStack itemStack) {
        this.zoomMultiplier = zoomMultiplier;
        this.overlayTexture = Optional.ofNullable(overlayTexture);
        this.overlayTextureWidth = overlayTextureWidth;
        this.overlayTextureHeight = overlayTextureHeight;
        this.itemStack = itemStack;
    }

    @Override
    public boolean isScoping(LivingExtension<?, ?> living) {
        PlayerExtension player;
        return living.getEntity().m_21211_() == this.itemStack && (!(living instanceof PlayerExtension) || !(player = (PlayerExtension)living).isHandcuffed());
    }

    @Override
    public float getZoomMultiplier(LivingExtension<?, ?> living) {
        return this.zoomMultiplier;
    }

    @Override
    public Optional<ResourceLocation> getOverlayTexture(LivingExtension<?, ?> living) {
        return this.overlayTexture;
    }

    @Override
    public int getOverlayTextureWidth() {
        return this.overlayTextureWidth;
    }

    @Override
    public int getOverlayTextureHeight() {
        return this.overlayTextureHeight;
    }
}

