/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.commands.dump;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.io.PrintStream;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import org.orecruncher.dsurround.DynamicSurroundings;
import org.orecruncher.dsurround.commands.CommandHelpers;
import org.orecruncher.environs.library.DimensionLibrary;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.mobeffects.library.FootstepLibrary;
import org.orecruncher.sndctrl.library.AcousticLibrary;

public class DumpCommand {
    public static void register(@Nonnull CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dsdump").requires(req -> req.m_6761_(0))).then(Commands.m_82127_((String)"acoustics").executes(cmd -> DumpCommand.dumpAcoustics((CommandSourceStack)cmd.getSource())))).then(Commands.m_82127_((String)"audioeffects").executes(cmd -> DumpCommand.dumpAudioEffects((CommandSourceStack)cmd.getSource())))).then(Commands.m_82127_((String)"blocks").executes(cmd -> DumpCommand.dumpBlocks((CommandSourceStack)cmd.getSource())))).then(Commands.m_82127_((String)"biomes").executes(cmd -> DumpCommand.dumpBiomes((CommandSourceStack)cmd.getSource())))).then(Commands.m_82127_((String)"items").executes(cmd -> DumpCommand.dumpItems((CommandSourceStack)cmd.getSource())))).then(Commands.m_82127_((String)"footsteps").executes(cmd -> DumpCommand.dumpFootsteps((CommandSourceStack)cmd.getSource())))).then(Commands.m_82127_((String)"mobeffects").executes(cmd -> DumpCommand.dumpMobeffects((CommandSourceStack)cmd.getSource())))).then(Commands.m_82127_((String)"blockstates").executes(cmd -> DumpCommand.dumpBlockStates((CommandSourceStack)cmd.getSource())))).then(Commands.m_82127_((String)"dimensions").executes(cmd -> DumpCommand.dumpDimensions((CommandSourceStack)cmd.getSource()))));
    }

    private static int dumpAcoustics(@Nonnull CommandSourceStack source) {
        return DumpCommand.handle(source, "dump.acoustics", AcousticLibrary::dump);
    }

    private static int dumpAudioEffects(@Nonnull CommandSourceStack source) {
        return DumpCommand.handle(source, "dump.audioeffects", DumpCommand::tbd);
    }

    private static int dumpBlocks(@Nonnull CommandSourceStack source) {
        return DumpCommand.handle(source, "dump.blocks", DumpCommand::tbd);
    }

    private static int dumpBiomes(@Nonnull CommandSourceStack source) {
        return DumpCommand.handle(source, "dump.biomes", DumpCommand::tbd);
    }

    private static int dumpFootsteps(@Nonnull CommandSourceStack source) {
        return DumpCommand.handle(source, "dump.footsteps", FootstepLibrary::dump);
    }

    private static int dumpItems(@Nonnull CommandSourceStack source) {
        return DumpCommand.handle(source, "dump.items", DumpCommand::tbd);
    }

    private static int dumpMobeffects(@Nonnull CommandSourceStack source) {
        return DumpCommand.handle(source, "dump.mobeffects", DumpCommand::tbd);
    }

    private static int dumpBlockStates(@Nonnull CommandSourceStack source) {
        return DumpCommand.handle(source, "dump.blockstates", DumpCommand::tbd);
    }

    private static int dumpDimensions(@Nonnull CommandSourceStack source) {
        return DumpCommand.handle(source, "dump.dimensions", DimensionLibrary::dump);
    }

    private static int handle(@Nonnull CommandSourceStack source, @Nonnull String cmdString, @Nonnull Supplier<Stream<String>> supplier) {
        try {
            if (GameUtils.getMC().m_91091_()) {
                String operation = cmdString.substring(5);
                String fileName = operation + ".txt";
                File target = new File(DynamicSurroundings.DUMP_PATH, fileName);
                CommandHelpers.scheduleOnClientThread(() -> {
                    try (PrintStream out = new PrintStream(target);){
                        Stream strm = (Stream)supplier.get();
                        strm.forEach(out::println);
                        out.flush();
                    }
                    catch (Throwable t) {
                        DynamicSurroundings.LOGGER.error(t, "Error writing dump file '%s'", target.toString());
                    }
                });
                CommandHelpers.sendSuccess(source, "dump", operation, target.toString());
            } else {
                CommandHelpers.sendFailure(source, cmdString);
            }
        }
        catch (Throwable t) {
            CommandHelpers.sendFailure(source, cmdString);
        }
        return 0;
    }

    private static Stream<String> tbd() {
        ImmutableList result = ImmutableList.of((Object)"Not hooked up");
        return result.stream();
    }
}

