/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.orecruncher.dsurround.DynamicSurroundings;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.handlers.Manager;
import org.orecruncher.environs.library.Constants;
import org.orecruncher.environs.library.Libraries;
import org.orecruncher.environs.shaders.ShaderPrograms;
import org.orecruncher.lib.logging.ModLog;
import org.orecruncher.sndctrl.api.IMC;

@Mod(value="environs")
public final class Environs {
    public static final String MOD_ID = "environs";
    public static final ModLog LOGGER = new ModLog(Environs.class);

    public Environs() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
            MinecraftForge.EVENT_BUS.register((Object)this);
            Config.setup();
            ShaderPrograms.MANAGER.initShaders();
            DynamicSurroundings.doConfigMenuSetup();
        }
    }

    private void clientSetup(@Nonnull FMLClientSetupEvent event) {
        if (((Boolean)Config.CLIENT.effects.disableUnderwaterParticles.get()).booleanValue()) {
            Minecraft.m_91087_().f_91061_.m_107381_((ParticleType)ParticleTypes.f_123768_, (ParticleProvider)null);
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        IMC.registerSoundCategory(Constants.BIOMES);
        IMC.registerSoundCategory(Constants.SPOT_SOUNDS);
        IMC.registerSoundCategory(Constants.WATERFALL);
        IMC.registerCompletionCallback(Libraries::initialize);
        IMC.registerCompletionCallback(Libraries::complete);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void clientConnect(@Nonnull ClientPlayerNetworkEvent.LoggedInEvent event) {
        Manager.connect();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void clientDisconnect(@Nonnull ClientPlayerNetworkEvent.LoggedOutEvent event) {
        Manager.disconnect();
    }
}

