/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.gui.ColorPalette;
import org.orecruncher.lib.particles.AnimatedMote;

@OnlyIn(value=Dist.CLIENT)
public class MoteFireFly
extends AnimatedMote {
    private static final float XZ_MOTION_DELTA = 0.2f;
    private static final float Y_MOTION_DELTA = 0.1f;
    private static final float ACCELERATION = 0.004f;
    private boolean doRender;

    public MoteFireFly(@Nonnull BlockGetter world, double x, double y, double z) {
        super((SpriteSet)GameUtils.getMC().f_91061_.f_107295_.get(ParticleTypes.f_123815_.getRegistryName()), world, x, y, z, 0.0, 0.0, 0.0);
        this.motionX = RANDOM.nextGaussian() * (double)0.2f;
        this.motionZ = RANDOM.nextGaussian() * (double)0.2f;
        this.motionY = RANDOM.nextGaussian() * (double)0.1f;
        this.xAcceleration = RANDOM.nextGaussian() * (double)0.004f;
        this.yAcceleration = RANDOM.nextGaussian() / 2.0 * (double)0.004f;
        this.zAcceleration = RANDOM.nextGaussian() * (double)0.004f;
        this.gravity = 0.0;
        this.particleScale *= 0.01875f;
        this.maxAge = 120 + RANDOM.nextInt(12);
        this.setColor(ColorPalette.MC_YELLOW);
        this.setColorFade(ColorPalette.MC_GREEN);
    }

    @Override
    public void update() {
        super.update();
        this.doRender = this.age < this.maxAge / 3 || (this.age + this.maxAge) / 3 % 2 == 0;
    }

    @Override
    public void renderParticle(@Nonnull VertexConsumer buffer, @Nonnull Camera info, float partialTicks) {
        if (this.doRender) {
            super.renderParticle(buffer, info, partialTicks);
        }
    }
}

