/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects.particles;

import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.effects.JetEffect;
import org.orecruncher.environs.effects.particles.Collections;
import org.orecruncher.environs.effects.particles.SteamCloudParticle;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.particles.ParticleCollisionResult;
import org.orecruncher.sndctrl.api.acoustics.Library;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleHooks {
    private static final ResourceLocation STEAM_HISS_ACOUSTIC = new ResourceLocation("environs", "steam.hiss");
    private static final ResourceLocation WATER_DRIP_ACOUSTIC = new ResourceLocation("environs", "waterdrips");
    private static final ResourceLocation WATER_DROP_ACOUSTIC = new ResourceLocation("environs", "waterdrops");
    private static final double LIQUID_HEIGHT_ADJUST = 0.2111111111111111;

    private ParticleHooks() {
    }

    private static boolean doRipples() {
        return (Boolean)Config.CLIENT.effects.enableWaterRipples.get();
    }

    public static void dripHandler(@Nonnull DripParticle particle) {
        if (particle.f_107213_ < -63.0) {
            particle.m_107274_();
            return;
        }
        ClientLevel world = GameUtils.getWorld();
        BlockPos pos = new BlockPos(particle.f_107212_, particle.f_107213_ - 0.01, particle.f_107214_);
        BlockState state = world.m_8055_(pos);
        FluidState fluidState = world.m_6425_(pos);
        if (!fluidState.m_76178_()) {
            float fluidHeight = fluidState.m_76155_((BlockGetter)world, pos);
            float actualHeight = fluidHeight + (float)pos.m_123342_();
            if (fluidHeight < 1.0f && particle.f_107213_ <= (double)actualHeight) {
                ResourceLocation acoustic;
                boolean isDripLava = particle.f_106049_.m_205067_(FluidTags.f_13132_);
                Vec3 vecPos = new Vec3(particle.f_107212_, particle.f_107213_, particle.f_107214_);
                if (fluidState.m_205070_(FluidTags.f_13132_)) {
                    if (isDripLava) {
                        acoustic = WATER_DROP_ACOUSTIC;
                    } else {
                        ParticleHooks.createSteamCloud((BlockGetter)world, vecPos);
                        acoustic = STEAM_HISS_ACOUSTIC;
                    }
                } else {
                    if (ParticleHooks.doRipples()) {
                        Collections.addWaterRipple((BlockGetter)world, particle.f_107212_, particle.f_107213_ + 0.01, particle.f_107214_);
                    }
                    if (isDripLava) {
                        ParticleHooks.createSteamCloud((BlockGetter)world, vecPos);
                        acoustic = STEAM_HISS_ACOUSTIC;
                    } else {
                        acoustic = WATER_DRIP_ACOUSTIC;
                    }
                }
                Library.resolve(acoustic).playAt(vecPos);
                particle.m_107274_();
                return;
            }
        }
        if (particle.f_107218_) {
            ResourceLocation acoustic;
            Vec3 vecPos = new Vec3(particle.f_107212_, particle.f_107213_, particle.f_107214_);
            if (ParticleHooks.doSteamHiss(particle.f_106049_, state)) {
                ParticleHooks.createSteamCloud((BlockGetter)world, vecPos);
                acoustic = STEAM_HISS_ACOUSTIC;
                particle.m_107274_();
                particle.f_107218_ = false;
            } else {
                acoustic = WATER_DROP_ACOUSTIC;
            }
            Library.resolve(acoustic).playAt(vecPos);
        }
    }

    public static void splashHandler(@Nonnull Fluid fluidType, @Nonnull ParticleCollisionResult collision, boolean playSound) {
        float actualHeight;
        BlockGetter world = collision.world;
        Vec3 particlePos = collision.position;
        BlockPos pos = new BlockPos(particlePos.f_82479_, particlePos.f_82480_ - 0.01, particlePos.f_82481_);
        BlockState state = collision.state;
        if (collision.onGround) {
            ResourceLocation acoustic;
            if (ParticleHooks.doSteamHiss(fluidType, state)) {
                ParticleHooks.createSteamCloud(world, particlePos);
                acoustic = STEAM_HISS_ACOUSTIC;
            } else {
                acoustic = WATER_DROP_ACOUSTIC;
            }
            if (playSound) {
                Library.resolve(acoustic).playAt(particlePos);
            }
            return;
        }
        FluidState fluidState = collision.fluidState;
        if (!fluidState.m_76178_() && fluidState.m_76170_() && world.m_8055_(pos.m_7494_()).m_60767_() == Material.f_76296_ && particlePos.f_82480_ <= (double)(actualHeight = fluidState.m_76155_(world, pos) + (float)pos.m_123342_())) {
            ResourceLocation acoustic;
            boolean isDripLava = fluidType.m_205067_(FluidTags.f_13132_);
            if (fluidState.m_205070_(FluidTags.f_13132_)) {
                if (isDripLava) {
                    acoustic = WATER_DROP_ACOUSTIC;
                } else {
                    ParticleHooks.createSteamCloud(world, particlePos);
                    acoustic = STEAM_HISS_ACOUSTIC;
                }
            } else {
                if (ParticleHooks.doRipples()) {
                    Collections.addWaterRipple(world, particlePos.f_82479_, (double)actualHeight + 0.2111111111111111, particlePos.f_82481_);
                }
                if (isDripLava) {
                    ParticleHooks.createSteamCloud(world, particlePos);
                    acoustic = STEAM_HISS_ACOUSTIC;
                } else {
                    acoustic = WATER_DRIP_ACOUSTIC;
                }
            }
            if (playSound) {
                Library.resolve(acoustic).playAt(particlePos);
            }
        }
    }

    public static boolean spawnRippleOnBlock(@Nonnull Level world, @Nonnull Vec3 position) {
        if (ParticleHooks.doRipples()) {
            BlockPos pos = new BlockPos(position.f_82479_, position.f_82480_ - 0.01, position.f_82481_);
            FluidState fluidState = world.m_6425_(pos);
            if (fluidState.m_76178_()) {
                return false;
            }
            float actualHeight = fluidState.m_76155_((BlockGetter)world, pos) + (float)pos.m_123342_();
            Collections.addWaterRipple((BlockGetter)world, position.f_82479_, (double)actualHeight + 0.2111111111111111, position.f_82481_);
            return true;
        }
        return false;
    }

    private static void createSteamCloud(@Nonnull BlockGetter world, @Nonnull Vec3 pos) {
        SteamCloudParticle steamCloud = new SteamCloudParticle((Level)GameUtils.getWorld(), pos.f_82479_, pos.f_82480_ + 0.01, pos.f_82481_, 0.01);
        GameUtils.getMC().f_91061_.m_107344_((Particle)steamCloud);
    }

    private static boolean doSteamHiss(@Nonnull Fluid particleFluid, @Nonnull BlockState state) {
        return JetEffect.HOTBLOCK_PREDICATE.test(state) && particleFluid.m_205067_(FluidTags.f_13131_);
    }
}

