/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.handlers;

import it.unimi.dsi.fastutil.objects.Reference2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.handlers.BackgroundAcousticEmitter;
import org.orecruncher.environs.handlers.CommonState;
import org.orecruncher.environs.handlers.HandlerBase;
import org.orecruncher.environs.library.BiomeInfo;
import org.orecruncher.environs.library.BiomeLibrary;
import org.orecruncher.environs.scanner.BiomeScanner;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.events.DiagnosticEvent;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;
import org.orecruncher.sndctrl.audio.AudioEngine;

@OnlyIn(value=Dist.CLIENT)
public class BiomeSoundEffects
extends HandlerBase {
    public static final int SCAN_INTERVAL = 4;
    public static final int SPOT_SOUND_MIN_RANGE = 8;
    public static final int SPOT_SOUND_MAX_RANGE = 16;
    private static final Reference2FloatOpenHashMap<IAcoustic> WORK_MAP = new Reference2FloatOpenHashMap(8);
    private final BiomeScanner biomes = new BiomeScanner();
    private final ObjectArray<BackgroundAcousticEmitter> emitters = new ObjectArray(8);

    BiomeSoundEffects() {
        super("Biome Sounds");
    }

    @Override
    public boolean doTick(long tick) {
        return CommonState.getDimensionInfo().playBiomeSounds();
    }

    private boolean doBiomeSounds() {
        return CommonState.isUnderground() || !CommonState.isInside() || CommonState.getDimensionInfo().alwaysOutside();
    }

    private void generateBiomeSounds() {
        float area = this.biomes.getBiomeArea();
        for (Reference2IntMap.Entry kvp : this.biomes.getBiomes().reference2IntEntrySet()) {
            Collection<IAcoustic> acoustics = ((BiomeInfo)kvp.getKey()).findSoundMatches();
            float volume = 0.05f + 0.95f * ((float)kvp.getIntValue() / area);
            for (IAcoustic acoustic : acoustics) {
                WORK_MAP.addTo((Object)acoustic, volume);
            }
        }
    }

    @Override
    public void process(@Nonnull Player player) {
        this.emitters.forEach(BackgroundAcousticEmitter::tick);
        if (TickCounter.getTickCount() % 4L == 0L) {
            this.biomes.tick();
            this.handleBiomeSounds(player);
        }
    }

    @Override
    public void onConnect() {
        this.clearSounds();
    }

    @Override
    public void onDisconnect() {
        this.clearSounds();
    }

    private void handleBiomeSounds(@Nonnull Player player) {
        this.biomes.tick();
        WORK_MAP.clear();
        if (player.m_6084_()) {
            IAcoustic sound;
            BiomeInfo playerBiome;
            IAcoustic sound2;
            boolean biomeSounds = this.doBiomeSounds();
            if (biomeSounds) {
                this.generateBiomeSounds();
            }
            ObjectArray<IAcoustic> playerSounds = new ObjectArray<IAcoustic>();
            BiomeLibrary.PLAYER_INFO.findSoundMatches(playerSounds);
            BiomeLibrary.VILLAGE_INFO.findSoundMatches(playerSounds);
            playerSounds.forEach(fx -> WORK_MAP.put(fx, 1.0f));
            if (biomeSounds && (sound2 = (playerBiome = CommonState.getPlayerBiome()).getSpotSound(RANDOM)) != null) {
                sound2.playNear((Entity)player, 8, 16);
            }
            if ((sound = BiomeLibrary.PLAYER_INFO.getSpotSound(RANDOM)) != null) {
                sound.playNear((Entity)player, 8, 16);
            }
        }
        this.queueAmbientSounds();
    }

    private void queueAmbientSounds() {
        this.emitters.removeIf(entry -> {
            if (entry.isDonePlaying()) {
                return true;
            }
            float volume = WORK_MAP.getFloat((Object)entry.getSource());
            if (volume > 0.0f) {
                entry.setVolumeThrottle(volume);
                if (entry.isFading()) {
                    entry.unfade();
                }
                WORK_MAP.removeFloat((Object)entry.getSource());
            } else if (!entry.isFading()) {
                entry.fade();
            }
            return false;
        });
        WORK_MAP.forEach((fx, volume) -> {
            BackgroundAcousticEmitter e = new BackgroundAcousticEmitter((IAcoustic)fx);
            e.setVolumeThrottle(volume.floatValue());
            this.emitters.add(e);
        });
    }

    public void clearSounds() {
        this.emitters.forEach(BackgroundAcousticEmitter::stop);
        this.emitters.clear();
        WORK_MAP.clear();
        AudioEngine.stopAll();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void diagnostics(@Nonnull DiagnosticEvent event) {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            this.emitters.forEach(backgroundAcousticEmitter -> event.getLeft().add("EMITTER: " + backgroundAcousticEmitter.toString()));
        }
    }

    static {
        WORK_MAP.defaultReturnValue(0.0f);
    }
}

