/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.handlers;

import com.google.common.base.MoreObjects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import org.orecruncher.lib.math.TimerEMA;
import org.orecruncher.lib.random.XorShiftRandom;

@OnlyIn(value=Dist.CLIENT)
public class HandlerBase {
    protected static final Random RANDOM = XorShiftRandom.current();
    private final String handlerName;
    private final TimerEMA timer;

    HandlerBase(@Nonnull String name) {
        this.handlerName = name;
        this.timer = new TimerEMA(this.handlerName);
    }

    @Nonnull
    public TimerEMA getTimer() {
        return this.timer;
    }

    @Nonnull
    public final String getHandlerName() {
        return this.handlerName;
    }

    public boolean doTick(long tick) {
        return true;
    }

    public void process(@Nonnull Player player) {
    }

    public void onConnect() {
    }

    public void onDisconnect() {
    }

    final void updateTimer(long nanos) {
        this.timer.update(nanos);
    }

    final void connect0() {
        this.onConnect();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    final void disconnect0() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.onDisconnect();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getHandlerName()).toString();
    }
}

