/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.handlers;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.effects.emitters.ParticleEmitter;
import org.orecruncher.environs.handlers.CommonState;
import org.orecruncher.environs.handlers.HandlerBase;
import org.orecruncher.lib.BlockPosUtil;

@OnlyIn(value=Dist.CLIENT)
public class ParticleSystems
extends HandlerBase {
    private static final Predicate<ParticleEmitter> STANDARD = system -> {
        system.tick();
        return !system.isAlive();
    };
    private static ParticleSystems _instance = null;
    private final Long2ObjectOpenHashMap<ParticleEmitter> systems = new Long2ObjectOpenHashMap(512);
    private BlockPos lastPos = BlockPos.f_121853_;

    ParticleSystems() {
        super("Particle Systems");
    }

    @Override
    public boolean doTick(long tick) {
        return this.systems.size() > 0;
    }

    @Override
    public void process(@Nonnull Player player) {
        BlockPos current = CommonState.getPlayerPosition();
        boolean sittingStill = this.lastPos.equals((Object)current);
        this.lastPos = current;
        Predicate<ParticleEmitter> pred = STANDARD;
        if (!sittingStill) {
            double range = Config.CLIENT.effects.get_effectRange();
            BlockPos min = new BlockPos((double)current.m_123341_() - range, (double)current.m_123342_() - range, (double)current.m_123343_() - range);
            BlockPos max = new BlockPos((double)current.m_123341_() + range, (double)current.m_123342_() + range, (double)current.m_123343_() + range);
            pred = system -> {
                if (BlockPosUtil.notContains(system.getPos(), min, max)) {
                    system.setExpired();
                } else {
                    system.tick();
                }
                return !system.isAlive();
            };
        }
        this.systems.values().removeIf(pred);
    }

    @Override
    public void onConnect() {
        _instance = this;
        this.systems.clear();
    }

    @Override
    public void onDisconnect() {
        this.systems.clear();
        _instance = null;
    }

    public static boolean okToSpawn(@Nonnull BlockPos pos) {
        return !ParticleSystems._instance.systems.containsKey(pos.m_121878_());
    }

    public static void add(@Nonnull ParticleEmitter system) {
        ParticleSystems._instance.systems.put(system.getPos().m_121878_(), (Object)system);
    }
}

