/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.scanner;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.Environs;
import org.orecruncher.environs.handlers.CommonState;
import org.orecruncher.environs.library.BiomeInfo;
import org.orecruncher.environs.library.BiomeUtil;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.biomes.BiomeUtilities;

@OnlyIn(value=Dist.CLIENT)
public final class BiomeScanner {
    private static final int BIOME_SURVEY_RANGE = 18;
    private static final int MAX_BIOME_AREA = (int)Math.pow(37.0, 2.0);
    private final BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
    private int biomeArea;
    private Reference2IntOpenHashMap<BiomeInfo> weights = new Reference2IntOpenHashMap(8);
    private BiomeInfo surveyedBiome = null;
    private int surveyedDimension = 0;
    private BlockPos surveyedPosition = BlockPos.f_121853_;

    public void tick() {
        BlockPos position = CommonState.getPlayerPosition();
        BiomeInfo playerBiome = CommonState.getPlayerBiome();
        int dimId = CommonState.getDimensionId();
        if (this.surveyedBiome != playerBiome || this.surveyedDimension != dimId || this.surveyedPosition.compareTo((Vec3i)position) != 0 || TickCounter.getTickCount() % 20L == 0L) {
            this.surveyedBiome = playerBiome;
            this.surveyedDimension = dimId;
            this.surveyedPosition = position;
            this.biomeArea = 0;
            this.weights = new Reference2IntOpenHashMap(8);
            if (playerBiome.isFake()) {
                this.biomeArea = 1;
                this.weights.put((Object)playerBiome, 1);
            } else {
                LevelReader provider = CommonState.getBlockReader();
                for (int dZ = -18; dZ <= 18; ++dZ) {
                    for (int dX = -18; dX <= 18; ++dX) {
                        this.mutable.m_122178_(this.surveyedPosition.m_123341_() + dX, 0, this.surveyedPosition.m_123343_() + dZ);
                        Biome biome = BiomeUtilities.getClientBiome((BlockPos)this.mutable);
                        if (biome == null || biome.getRegistryName() == null) continue;
                        BiomeInfo info = BiomeUtil.getBiomeData(biome);
                        this.weights.addTo((Object)info, 1);
                    }
                }
                this.biomeArea = MAX_BIOME_AREA;
            }
            HashSet<ResourceLocation> seen = new HashSet<ResourceLocation>();
            for (Reference2IntMap.Entry kvp : this.weights.reference2IntEntrySet()) {
                ResourceLocation location = ((BiomeInfo)kvp.getKey()).getKey();
                if (seen.contains(location)) {
                    Environs.LOGGER.debug("Duplicate entry detected: %s", location.toString());
                    continue;
                }
                seen.add(location);
            }
        }
    }

    public int getBiomeArea() {
        return this.biomeArea;
    }

    public Reference2IntOpenHashMap<BiomeInfo> getBiomes() {
        return this.weights;
    }
}

