/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.scanner;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import org.orecruncher.environs.handlers.CommonState;
import org.orecruncher.environs.library.DimensionInfo;
import org.orecruncher.environs.library.DimensionLibrary;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.math.MathStuff;

@OnlyIn(value=Dist.CLIENT)
public final class CeilingCoverage {
    private static final int SURVEY_INTERVAL = 4;
    private static final int INSIDE_SURVEY_RANGE = 3;
    private static final float INSIDE_THRESHOLD = 0.6306818f;
    private static final Cell[] cells;
    private static final float TOTAL_POINTS;
    private static final ObjectArray<TagKey<Block>> NON_CEILING;
    private boolean reallyInside = false;

    public void tick() {
        if (TickCounter.getTickCount() % 4L == 0L) {
            DimensionInfo dimInfo = DimensionLibrary.getData((Level)GameUtils.getWorld());
            if (dimInfo.alwaysOutside()) {
                this.reallyInside = false;
            } else {
                BlockPos pos = CommonState.getPlayerPosition();
                float score = 0.0f;
                for (Cell cell : cells) {
                    score += cell.score(pos);
                }
                float ceilingCoverageRatio = 1.0f - score / TOTAL_POINTS;
                this.reallyInside = ceilingCoverageRatio > 0.6306818f;
            }
        }
    }

    public boolean isReallyInside() {
        return this.reallyInside;
    }

    static {
        NON_CEILING = new ObjectArray();
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                cellList.add(new Cell(new Vec3i(x, 0, z), 3));
            }
        }
        Collections.sort(cellList);
        cells = cellList.toArray(new Cell[0]);
        float totalPoints = 0.0f;
        for (Cell c : cellList) {
            totalPoints += c.potentialPoints();
        }
        TOTAL_POINTS = totalPoints;
        NON_CEILING.add((TagKey<Block>)BlockTags.f_13035_);
        NON_CEILING.add((TagKey<Block>)BlockTags.f_13055_);
        NON_CEILING.add((TagKey<Block>)BlockTags.f_13039_);
        NON_CEILING.add((TagKey<Block>)BlockTags.f_13032_);
        NON_CEILING.add((TagKey<Block>)Tags.Blocks.GLASS_PANES);
        NON_CEILING.add((TagKey<Block>)Tags.Blocks.CHESTS);
        NON_CEILING.add((TagKey<Block>)Tags.Blocks.FENCES);
        NON_CEILING.add((TagKey<Block>)Tags.Blocks.FENCE_GATES);
    }

    private static final class Cell
    implements Comparable<Cell> {
        private final Vec3i offset;
        private final float points;
        private final BlockPos.MutableBlockPos working;

        public Cell(@Nonnull Vec3i offset, int range) {
            this.offset = offset;
            float xV = range - MathStuff.abs(offset.m_123341_()) + 1;
            float zV = range - MathStuff.abs(offset.m_123343_()) + 1;
            float candidate = Math.min(xV, zV);
            this.points = candidate * candidate;
            this.working = new BlockPos.MutableBlockPos();
        }

        public float potentialPoints() {
            return this.points;
        }

        public float score(@Nonnull BlockPos playerPos) {
            this.working.m_122178_(playerPos.m_123341_() + this.offset.m_123341_(), playerPos.m_123342_() + this.offset.m_123342_(), playerPos.m_123343_() + this.offset.m_123343_());
            ClientLevel world = GameUtils.getWorld();
            int playerHeight = Math.max(playerPos.m_123342_() + 1, 0);
            this.working.m_122190_((Vec3i)WorldUtils.getPrecipitationHeight((LevelReader)world, (BlockPos)this.working));
            while (this.working.m_123342_() > playerHeight) {
                BlockState state = world.m_8055_((BlockPos)this.working);
                if (this.actsAsCeiling(state)) {
                    return 0.0f;
                }
                this.working.m_142448_(this.working.m_123342_() - 1);
            }
            return this.points;
        }

        @Override
        public int compareTo(@Nonnull Cell cell) {
            return -Float.compare(this.potentialPoints(), cell.potentialPoints());
        }

        @Nonnull
        public String toString() {
            return this.offset.toString() + " points: " + this.points;
        }

        private boolean actsAsCeiling(@Nonnull BlockState state) {
            if (!state.m_60767_().m_76334_()) {
                return false;
            }
            Block block = state.m_60734_();
            ITagManager blockTags = ForgeRegistries.BLOCKS.tags();
            for (TagKey<Block> tagKey : NON_CEILING) {
                if (!blockTags.getTag(tagKey).contains((Object)block)) continue;
                return false;
            }
            return true;
        }
    }
}

