/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.scanner;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.BlockPosUtil;

@OnlyIn(value=Dist.CLIENT)
public class Cuboid {
    protected final BlockPos[] vertices = new BlockPos[8];
    protected final int volume;
    protected final BlockPos minPoint;
    protected final BlockPos maxPoint;

    public Cuboid(@Nonnull BlockPos[] points) {
        this(points[0], points[1]);
    }

    public Cuboid(@Nonnull BlockPos vx1, @Nonnull BlockPos vx2) {
        this.minPoint = BlockPosUtil.createMinPoint(vx1, vx2);
        this.maxPoint = BlockPosUtil.createMaxPoint(vx1, vx2);
        BlockPos t = this.maxPoint.m_141950_((Vec3i)this.minPoint);
        this.volume = t.m_123341_() * t.m_123342_() * t.m_123343_();
        this.vertices[0] = this.minPoint;
        this.vertices[1] = this.maxPoint;
        this.vertices[2] = new BlockPos(this.minPoint.m_123341_(), this.maxPoint.m_123342_(), this.maxPoint.m_123343_());
        this.vertices[3] = new BlockPos(this.maxPoint.m_123341_(), this.minPoint.m_123342_(), this.minPoint.m_123343_());
        this.vertices[4] = new BlockPos(this.maxPoint.m_123341_(), this.minPoint.m_123342_(), this.maxPoint.m_123343_());
        this.vertices[5] = new BlockPos(this.minPoint.m_123341_(), this.minPoint.m_123342_(), this.maxPoint.m_123343_());
        this.vertices[6] = new BlockPos(this.minPoint.m_123341_(), this.maxPoint.m_123342_(), this.minPoint.m_123343_());
        this.vertices[7] = new BlockPos(this.maxPoint.m_123341_(), this.maxPoint.m_123342_(), this.minPoint.m_123343_());
    }

    public boolean contains(@Nonnull BlockPos p) {
        return BlockPosUtil.contains(p, this.minPoint, this.maxPoint);
    }

    @Nonnull
    public BlockPos maximum() {
        return this.maxPoint;
    }

    @Nonnull
    public BlockPos minimum() {
        return this.minPoint;
    }

    public long volume() {
        return this.volume;
    }

    @Nullable
    public Cuboid intersection(@Nonnull Cuboid o) {
        BlockPos vx1 = null;
        for (BlockPos vx : this.vertices) {
            if (!o.contains(vx)) continue;
            vx1 = vx;
            break;
        }
        if (vx1 == null) {
            return null;
        }
        BlockPos vx2 = null;
        for (BlockPos vx : o.vertices) {
            if (!this.contains(vx) || !BlockPosUtil.canFormCuboid(vx, vx1)) continue;
            vx2 = vx;
            break;
        }
        return vx2 == null ? null : new Cuboid(vx1, vx2);
    }
}

