/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.scanner;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.scanner.ComplementsPointIterator;
import org.orecruncher.environs.scanner.Cuboid;
import org.orecruncher.environs.scanner.CuboidPointIterator;
import org.orecruncher.environs.scanner.ScanContext;
import org.orecruncher.environs.scanner.Scanner;

@OnlyIn(value=Dist.CLIENT)
public abstract class CuboidScanner
extends Scanner {
    protected boolean scanFinished = false;
    protected Cuboid activeCuboid;
    protected CuboidPointIterator fullRange;
    protected BlockPos lastPos;
    protected int lastReference = 0;

    protected CuboidScanner(@Nonnull ScanContext locus, @Nonnull String name, int range, int blocksPerTick) {
        super(locus, name, range, blocksPerTick);
    }

    protected CuboidScanner(@Nonnull ScanContext locus, @Nonnull String name, int xRange, int yRange, int zRange) {
        super(locus, name, xRange, yRange, zRange);
    }

    protected CuboidScanner(@Nonnull ScanContext locus, @Nonnull String name, int xSize, int ySize, int zSize, int blocksPerTick) {
        super(locus, name, xSize, ySize, zSize, blocksPerTick);
    }

    public boolean isScanFinished() {
        return this.scanFinished;
    }

    protected BlockPos[] getMinMaxPointsForVolume(@Nonnull BlockPos pos) {
        BlockPos min = pos.m_142082_(-this.xRange, -this.yRange, -this.zRange);
        BlockPos max = pos.m_142082_(this.xRange, this.yRange, this.zRange);
        if (min.m_123342_() < -64) {
            min = new BlockPos(min.m_123341_(), -64, min.m_123343_());
        }
        return new BlockPos[]{min, max};
    }

    protected Cuboid getVolumeFor(BlockPos pos) {
        BlockPos[] points = this.getMinMaxPointsForVolume(pos);
        return new Cuboid(points);
    }

    protected void resetFullScan() {
        this.lastPos = this.locus.getCenter();
        this.lastReference = this.locus.getReference();
        this.scanFinished = false;
        BlockPos[] points = this.getMinMaxPointsForVolume(this.lastPos);
        this.activeCuboid = new Cuboid(points);
        this.fullRange = new CuboidPointIterator(points);
    }

    @Override
    public void tick() {
        BlockPos playerPos = this.locus.getCenter();
        if (playerPos.m_123342_() < -64) {
            this.fullRange = null;
        } else if (this.fullRange == null || this.locus.getReference() != this.lastReference) {
            this.resetFullScan();
            super.tick();
        } else if (this.lastPos.equals((Object)playerPos)) {
            if (!this.scanFinished) {
                super.tick();
            }
        } else {
            Cuboid newVolume;
            Cuboid oldVolume = this.activeCuboid != null ? this.activeCuboid : this.getVolumeFor(this.lastPos);
            Cuboid intersect = oldVolume.intersection(newVolume = this.getVolumeFor(playerPos));
            if (intersect == null || oldVolume.volume() < (oldVolume.volume() - intersect.volume()) * 2L) {
                this.resetFullScan();
                super.tick();
            } else if (this.scanFinished) {
                this.lastPos = playerPos;
                this.activeCuboid = newVolume;
                this.updateScan(newVolume, oldVolume, intersect);
            } else {
                super.tick();
            }
        }
    }

    public boolean doBlockUnscan() {
        return false;
    }

    public void blockUnscan(BlockState state, BlockPos pos, Random rand) {
    }

    protected void updateScan(@Nonnull Cuboid newVolume, @Nonnull Cuboid oldVolume, @Nonnull Cuboid intersect) {
        BlockState state;
        BlockPos point;
        BlockGetter provider = this.locus.getWorld();
        if (this.doBlockUnscan()) {
            ComplementsPointIterator newOutOfRange = new ComplementsPointIterator(oldVolume, intersect);
            point = newOutOfRange.next();
            while (point != null) {
                if (point.m_123342_() > 0 && this.interestingBlock(state = provider.m_8055_(point))) {
                    this.blockUnscan(state, point, this.random);
                }
                point = newOutOfRange.next();
            }
        }
        ComplementsPointIterator newInRange = new ComplementsPointIterator(newVolume, intersect);
        point = newInRange.next();
        while (point != null) {
            if (point.m_123342_() > 0 && this.interestingBlock(state = provider.m_8055_(point))) {
                this.blockScan(state, point, this.random);
            }
            point = newInRange.next();
        }
        this.scanFinished = true;
    }

    @Override
    @Nullable
    protected BlockPos nextPos(@Nonnull BlockPos.MutableBlockPos workingPos, @Nonnull Random rand) {
        BlockPos point;
        if (this.scanFinished) {
            return null;
        }
        int checked = 0;
        while ((point = this.fullRange.peek()) != null) {
            this.fullRange.next();
            if (point.m_123342_() > 0) {
                return point;
            }
            if (++checked < this.blocksPerTick) continue;
            return null;
        }
        this.scanFinished = true;
        return null;
    }

    protected boolean isInteresting(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        if (this.activeCuboid == null) {
            return false;
        }
        if (!this.activeCuboid.contains(pos)) {
            return false;
        }
        return this.interestingBlock(state);
    }

    public void onBlockUpdate(@Nonnull BlockPos pos) {
        try {
            BlockState state;
            if (this.activeCuboid != null && this.activeCuboid.contains(pos) && this.isInteresting(pos, state = this.locus.getWorld().m_8055_(pos))) {
                this.blockScan(state, pos, this.random);
            }
        }
        catch (Throwable t) {
            this.locus.getLogger().error(t, "onBlockUpdate() error", new Object[0]);
        }
    }
}

