/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.material.Material;

public final class MaterialUtils {
    private static final Reference2ObjectOpenHashMap<Material, String> materialMap = new Reference2ObjectOpenHashMap();
    private static final Map<String, Material> materialMapInv = new TreeMap<String, Material>(String.CASE_INSENSITIVE_ORDER);

    private MaterialUtils() {
    }

    @Nonnull
    public static Set<Material> getMaterials() {
        return materialMap.keySet();
    }

    @Nullable
    public static Material getMaterial(@Nonnull String name) {
        return materialMapInv.get(name);
    }

    @Nullable
    public static String getMaterialName(@Nonnull Material mat) {
        return (String)materialMap.get((Object)mat);
    }

    static {
        materialMap.defaultReturnValue((Object)"CUSTOM");
        materialMap.put((Object)Material.f_76296_, (Object)"AIR");
        materialMap.put((Object)Material.f_76297_, (Object)"STRUCTURE_VOID");
        materialMap.put((Object)Material.f_76298_, (Object)"PORTAL");
        materialMap.put((Object)Material.f_76299_, (Object)"CARPET");
        materialMap.put((Object)Material.f_76300_, (Object)"PLANTS");
        materialMap.put((Object)Material.f_76301_, (Object)"OCEAN_PLANT");
        materialMap.put((Object)Material.f_76302_, (Object)"TALL_PLANTS");
        materialMap.put((Object)Material.f_76303_, (Object)"NETHER_PLANTS");
        materialMap.put((Object)Material.f_76304_, (Object)"SEA_GRASS");
        materialMap.put((Object)Material.f_76305_, (Object)"WATER");
        materialMap.put((Object)Material.f_76306_, (Object)"BUBBLE_COLUMN");
        materialMap.put((Object)Material.f_76307_, (Object)"LAVA");
        materialMap.put((Object)Material.f_76308_, (Object)"SNOW");
        materialMap.put((Object)Material.f_76309_, (Object)"FIRE");
        materialMap.put((Object)Material.f_76310_, (Object)"MISCELLANEOUS");
        materialMap.put((Object)Material.f_76311_, (Object)"WEB");
        materialMap.put((Object)Material.f_76312_, (Object)"REDSTONE_LIGHT");
        materialMap.put((Object)Material.f_76313_, (Object)"CLAY");
        materialMap.put((Object)Material.f_76314_, (Object)"EARTH");
        materialMap.put((Object)Material.f_76315_, (Object)"ORGANIC");
        materialMap.put((Object)Material.f_76316_, (Object)"PACKED_ICE");
        materialMap.put((Object)Material.f_76317_, (Object)"SAND");
        materialMap.put((Object)Material.f_76318_, (Object)"SPONGE");
        materialMap.put((Object)Material.f_76319_, (Object)"SHULKER");
        materialMap.put((Object)Material.f_76320_, (Object)"WOOD");
        materialMap.put((Object)Material.f_76321_, (Object)"NETHER_WOOD");
        materialMap.put((Object)Material.f_76270_, (Object)"BAMBOO_SAPLING");
        materialMap.put((Object)Material.f_76271_, (Object)"BAMBOO");
        materialMap.put((Object)Material.f_76272_, (Object)"WOOL");
        materialMap.put((Object)Material.f_76273_, (Object)"TNT");
        materialMap.put((Object)Material.f_76274_, (Object)"LEAVES");
        materialMap.put((Object)Material.f_76275_, (Object)"GLASS");
        materialMap.put((Object)Material.f_76276_, (Object)"ICE");
        materialMap.put((Object)Material.f_76277_, (Object)"CACTUS");
        materialMap.put((Object)Material.f_76278_, (Object)"ROCK");
        materialMap.put((Object)Material.f_76279_, (Object)"IRON");
        materialMap.put((Object)Material.f_76280_, (Object)"SNOW_BLOCK");
        materialMap.put((Object)Material.f_76281_, (Object)"ANVIL");
        materialMap.put((Object)Material.f_76282_, (Object)"BARRIER");
        materialMap.put((Object)Material.f_76283_, (Object)"PISTON");
        materialMap.put((Object)Material.f_76285_, (Object)"GOURD");
        materialMap.put((Object)Material.f_76286_, (Object)"DRAGON_EGG");
        materialMap.put((Object)Material.f_76287_, (Object)"CAKE");
        for (Map.Entry kvp : materialMap.entrySet()) {
            materialMapInv.put((String)kvp.getValue(), (Material)kvp.getKey());
        }
    }
}

