/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import java.lang.reflect.Array;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class Utilities {
    private Utilities() {
    }

    @SafeVarargs
    @Nonnull
    public static <T> T firstNonNull(T ... objs) {
        if (objs != null && objs.length > 0) {
            for (T o : objs) {
                if (o == null) continue;
                return o;
            }
        }
        throw new NullPointerException();
    }

    @Nonnull
    public static <S, T> Optional<T> safeCast(@Nullable S candidate, @Nonnull Class<T> target) {
        return target.isInstance(candidate) ? Optional.of(target.cast(candidate)) : Optional.empty();
    }

    public static int[] splitToInts(@Nonnull String str, char splitChar) {
        String[] tokens = StringUtils.split((String)str, (char)splitChar);
        if (tokens == null || tokens.length == 0) {
            return new int[0];
        }
        int[] result = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            result[i] = Integer.parseInt(tokens[i]);
        }
        return result;
    }

    @Nonnull
    public static <T> T[] append(@Nonnull T[] a, @Nullable T b) {
        if (b == null) {
            return a;
        }
        int aLen = a.length;
        Object[] c = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + 1);
        System.arraycopy(a, 0, c, 0, aLen);
        c[aLen] = b;
        return c;
    }

    public static String safeResourcePath(@Nonnull String path) {
        return path.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9/._\\-]", ".");
    }
}

