/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.blockstate;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.orecruncher.lib.Lib;
import org.orecruncher.lib.blockstate.BlockStateMatcher;

public class BlockStateProperties {
    public static final BlockStateProperties NONE = new BlockStateProperties();
    private final Map<Property<?>, Comparable<?>> props;

    private BlockStateProperties() {
        this.props = ImmutableMap.of();
    }

    public BlockStateProperties(@Nonnull BlockState state) {
        this((Map<Property<?>, Comparable<?>>)state.m_61148_());
    }

    public BlockStateProperties(@Nonnull Map<Property<?>, Comparable<?>> props) {
        this.props = props;
    }

    public boolean matches(@Nonnull BlockState state) {
        try {
            for (Map.Entry<Property<?>, Comparable<?>> kvp : this.props.entrySet()) {
                Comparable comp = state.m_61143_(kvp.getKey());
                if (comp.equals(kvp.getValue())) continue;
                return false;
            }
            return true;
        }
        catch (Throwable ignored) {
            Lib.LOGGER.warn("Property list %s does not correspond the properties in %s", this.toString(), new BlockStateMatcher(state).toString());
            return false;
        }
    }

    public boolean matches(@Nonnull BlockStateProperties props) {
        return this.matches(props.props);
    }

    public boolean matches(@Nonnull Map<Property<?>, Comparable<?>> m) {
        try {
            if (this.props == m) {
                return true;
            }
            if (this.props.size() > m.size()) {
                return false;
            }
            for (Map.Entry<Property<?>, Comparable<?>> kvp : this.props.entrySet()) {
                Comparable<?> comp = m.get(kvp.getKey());
                if (comp.equals(kvp.getValue())) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public int hashCode() {
        int code = 0;
        for (Map.Entry<Property<?>, Comparable<?>> kvp : this.props.entrySet()) {
            code = code * 31 + kvp.getKey().hashCode();
            code = code * 31 + kvp.getValue().hashCode();
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockStateProperties)) {
            return false;
        }
        BlockStateProperties e = (BlockStateProperties)obj;
        return this.props.size() == e.props.size() && this.matches(e.props);
    }

    @Nonnull
    public String getFormattedProperties() {
        if (this.props.size() == 0) {
            return "";
        }
        String txt = this.props.entrySet().stream().map(kvp -> ((Property)kvp.getKey()).m_61708_() + "=" + ((Comparable)kvp.getValue()).toString()).collect(Collectors.joining(","));
        return "[" + txt + "]";
    }

    @Nonnull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getFormattedProperties()).toString();
    }
}

