/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.events;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class BlockUpdateEvent
extends Event {
    private final Collection<BlockPos> positions;
    private final Set<BlockPos> expanded;

    public BlockUpdateEvent(@Nonnull Collection<BlockPos> positions) {
        this.positions = positions;
        this.expanded = new ObjectOpenHashSet();
    }

    @Nonnull
    public Collection<BlockPos> getPositions() {
        return this.positions;
    }

    @Nonnull
    public Collection<BlockPos> getExpandedPositions() {
        if (this.expanded.size() == 0) {
            for (BlockPos center : this.positions) {
                this.expand(center, this.expanded);
            }
        }
        return this.expanded;
    }

    protected void expand(@Nonnull BlockPos center, @Nonnull Set<BlockPos> result) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    result.add(center.m_142082_(i, j, k));
                }
            }
        }
    }
}

