/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.particles;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.particles.AgeableMote;
import org.orecruncher.lib.particles.ParticleCollisionResult;

@OnlyIn(value=Dist.CLIENT)
public abstract class MotionMote
extends AgeableMote {
    protected double motionX;
    protected double motionY;
    protected double motionZ;
    protected double gravity;
    protected double prevX;
    protected double prevY;
    protected double prevZ;

    protected MotionMote(@Nonnull BlockGetter world, double x, double y, double z, double dX, double dY, double dZ) {
        super(world, x, y, z);
        this.prevX = this.posX;
        this.prevY = this.posY;
        this.prevZ = this.posZ;
        this.motionX = dX;
        this.motionY = dY;
        this.motionZ = dZ;
        this.gravity = 0.06;
    }

    @Override
    protected float renderX(Camera info, float partialTicks) {
        return (float)(Mth.m_14139_((double)partialTicks, (double)this.prevX, (double)this.posX) - info.m_90583_().m_7096_());
    }

    @Override
    protected float renderY(Camera info, float partialTicks) {
        return (float)(Mth.m_14139_((double)partialTicks, (double)this.prevY, (double)this.posY) - info.m_90583_().m_7098_());
    }

    @Override
    protected float renderZ(Camera info, float partialTicks) {
        return (float)(Mth.m_14139_((double)partialTicks, (double)this.prevZ, (double)this.posZ) - info.m_90583_().m_7094_());
    }

    @Nonnull
    protected Optional<ParticleCollisionResult> detectCollision() {
        double height;
        BlockState state = this.world.m_8055_((BlockPos)this.position);
        if (state.m_60767_() == Material.f_76296_) {
            return Optional.empty();
        }
        FluidState fluid = state.m_60819_();
        if (!fluid.m_76178_() && (height = (double)(fluid.m_76155_(this.world, (BlockPos)this.position) + (float)this.position.m_123342_())) >= this.posY) {
            return Optional.of(new ParticleCollisionResult(this.world, new Vec3(this.posX, height, this.posZ), state, false, fluid));
        }
        if (state.m_60767_().m_76334_()) {
            double height2;
            VoxelShape shape = state.m_60742_(this.world, (BlockPos)this.position, CollisionContext.m_82749_());
            if (!shape.m_83281_() && (height2 = shape.m_83297_(Direction.Axis.Y) + (double)this.position.m_123342_()) >= this.posY) {
                return Optional.of(new ParticleCollisionResult(this.world, new Vec3(this.posX, height2, this.posZ), state, true, null));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    protected void handleCollision(@Nonnull ParticleCollisionResult collision) {
        this.kill();
    }

    @Override
    protected void update() {
        this.prevX = this.posX;
        this.prevY = this.posY;
        this.prevZ = this.posZ;
        this.motionY -= this.gravity;
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        this.position.m_122169_(this.posX, this.posY, this.posZ);
        Optional<ParticleCollisionResult> result = this.detectCollision();
        if (result.isPresent()) {
            this.handleCollision(result.get());
        } else {
            this.motionX *= (double)0.98f;
            this.motionY *= (double)0.98f;
            this.motionZ *= (double)0.98f;
        }
    }
}

