/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.service;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.orecruncher.dsurround.DynamicSurroundings;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.Singleton;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.fml.ForgeUtils;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.resource.ResourceUtils;
import org.orecruncher.lib.service.IModuleService;

@Mod.EventBusSubscriber(modid="dsurround", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ModuleServiceManager
implements ResourceManagerReloadListener {
    private static final IModLog LOGGER = DynamicSurroundings.LOGGER.createChild(ModuleServiceManager.class);
    private static final Singleton<ModuleServiceManager> instance = new Singleton<ModuleServiceManager>(ModuleServiceManager::new);
    private final ObjectArray<IModuleService> services = new ObjectArray();
    private boolean playerJoined = false;
    private boolean customTagsEventFired = false;
    private boolean vanillaTagsEventFired = false;
    private boolean reloadFired = false;

    private ModuleServiceManager() {
        ResourceManager resourceManager = GameUtils.getMC().m_91098_();
        ((ReloadableResourceManager)resourceManager).m_7217_((PreparableReloadListener)this);
    }

    public static ModuleServiceManager instance() {
        return instance.get();
    }

    public void add(@Nonnull IModuleService svc) {
        this.services.add(svc);
    }

    private void reload() {
        ForgeUtils.getEnabledResourcePacks().forEach(p -> {
            LOGGER.debug("Resource pack '%s'", p.m_10446_());
            LOGGER.debug("+  %s", p.m_10429_().getString());
            LOGGER.debug("+  %s", p.m_10442_().getString());
        });
        this.performAction("reload", IModuleService::reload);
        this.services.forEach(IModuleService::log);
    }

    public void m_6213_(@Nonnull ResourceManager resourceManager) {
        this.reportStatus("Received Resource reload callback");
        ResourceUtils.clearCache();
        this.reload();
    }

    private boolean readyForReload() {
        return this.playerJoined && (this.vanillaTagsEventFired || this.customTagsEventFired);
    }

    private void reportStatus(@Nonnull String msg) {
        String txt = String.format("%s (playerJoined: %b, reloadFired: %b, customTagsEventFired: %b, vanillaTagsEventFired: %b)", msg, this.playerJoined, this.reloadFired, this.customTagsEventFired, this.vanillaTagsEventFired);
        LOGGER.info(txt, new Object[0]);
    }

    private void reloadIfReady() {
        if (!this.reloadFired && this.readyForReload()) {
            this.reloadFired = true;
            this.reload();
        }
    }

    private void clearReloadState() {
        this.reportStatus("Clearing reload state");
        this.playerJoined = false;
        this.reloadFired = false;
        this.customTagsEventFired = false;
        this.vanillaTagsEventFired = false;
    }

    @SubscribeEvent
    public static void entityJoinWorld(@Nonnull EntityJoinWorldEvent event) {
        Player player = GameUtils.getPlayer();
        if (player != null && player.m_20193_().m_5776_() && player.m_142049_() == event.getEntity().m_142049_()) {
            ModuleServiceManager.instance().joinWorld(event);
        }
    }

    private void joinWorld(@Nonnull EntityJoinWorldEvent ignore) {
        this.playerJoined = true;
        this.reportStatus("EntityJoinWorldEvent fired");
        this.reloadIfReady();
    }

    @SubscribeEvent
    public static void onLoad(@Nonnull TagsUpdatedEvent event) {
        ModuleServiceManager.instance().load(event);
    }

    private void load(@Nonnull TagsUpdatedEvent event) {
        this.vanillaTagsEventFired = true;
        this.reloadIfReady();
    }

    @SubscribeEvent
    public static void onStop(@Nonnull ClientPlayerNetworkEvent.LoggedOutEvent event) {
        ModuleServiceManager.instance().stop();
    }

    private void stop() {
        this.performAction("stop", IModuleService::stop);
        this.clearReloadState();
    }

    private void performAction(@Nonnull String actionName, @Nonnull Consumer<IModuleService> action) {
        LOGGER.info("Starting action '%s'", actionName);
        long start = System.nanoTime();
        List<String> results = this.services.stream().map(svc -> {
            long begin = System.nanoTime();
            action.accept((IModuleService)svc);
            long duration = System.nanoTime() - begin;
            return String.format("Action '%s::%s' took %dmsecs", svc.name(), actionName, (long)((double)duration / 1000000.0));
        }).collect(Collectors.toList());
        long duration = System.nanoTime() - start;
        results.forEach(x$0 -> LOGGER.debug((String)x$0, new Object[0]));
        LOGGER.info("Overall Action '%s' took %dmsecs", actionName, (long)((double)duration / 1000000.0));
    }
}

