/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.validation;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.lib.validation.ValidationException;

public class ValidationHelpers {
    private ValidationHelpers() {
    }

    public static void notNull(@Nonnull String field, @Nullable Object value, @Nullable Consumer<String> errorLogger) throws ValidationException {
        if (value != null) {
            return;
        }
        ValidationHelpers.handleException(new ValidationException(field, "Must not be null", new Object[0]), errorLogger);
    }

    public static <T> void hasElements(@Nonnull String field, @Nullable List<T> elements, @Nullable Consumer<String> errorLogger) throws ValidationException {
        ValidationHelpers.notNull(field, elements, errorLogger);
        if (elements != null) {
            if (elements.size() > 0) {
                return;
            }
            ValidationHelpers.handleException(new ValidationException(field, "Has no elements", new Object[0]), errorLogger);
        }
    }

    public static <T> void hasElements(@Nonnull String field, @Nullable T[] elements, @Nullable Consumer<String> errorLogger) throws ValidationException {
        ValidationHelpers.notNull(field, elements, errorLogger);
        if (elements != null) {
            if (elements.length > 0) {
                return;
            }
            ValidationHelpers.handleException(new ValidationException(field, "Has no elements", new Object[0]), errorLogger);
        }
    }

    public static void isOneOf(@Nonnull String field, @Nullable String value, boolean ignoreCase, @Nonnull String[] values, @Nullable Consumer<String> errorLogger) throws ValidationException {
        ValidationHelpers.notNull(field, value, errorLogger);
        ValidationHelpers.hasElements(field, values, errorLogger);
        if (value != null) {
            Function<String, Integer> check = ignoreCase ? value::compareToIgnoreCase : value::compareTo;
            for (String s : values) {
                if (check.apply(s) != 0) continue;
                return;
            }
            String possibles = String.join((CharSequence)",", values);
            ValidationHelpers.handleException(new ValidationException(field, "Invalid value \"%s\"; must be one of \"%s\"", value, possibles), errorLogger);
        }
    }

    public static void inRange(@Nonnull String field, int value, int min, int max, @Nullable Consumer<String> errorLogger) throws ValidationException {
        if (value >= min && value <= max) {
            return;
        }
        ValidationHelpers.handleException(new ValidationException(field, "Invalid value \"%s\"; must be between %d and %d inclusive", value, min, max), errorLogger);
    }

    public static void inRange(@Nonnull String field, float value, float min, float max, @Nullable Consumer<String> errorLogger) throws ValidationException {
        if (value >= min && value <= max) {
            return;
        }
        ValidationHelpers.handleException(new ValidationException(field, "Invalid value \"%s\"; must be between %f and %f inclusive", Float.valueOf(value), Float.valueOf(min), Float.valueOf(max)), errorLogger);
    }

    public static void inRange(@Nonnull String field, double value, double min, double max, @Nullable Consumer<String> errorLogger) throws ValidationException {
        if (value >= min && value <= max) {
            return;
        }
        ValidationHelpers.handleException(new ValidationException(field, "Invalid value \"%s\"; must be between %f and %f inclusive", value, min, max), errorLogger);
    }

    public static void notNullOrEmpty(@Nonnull String field, @Nonnull String value, @Nullable Consumer<String> errorLogger) throws ValidationException {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return;
        }
        ValidationHelpers.handleException(new ValidationException(field, "Must not be null or empty", new Object[0]), errorLogger);
    }

    public static void notNullOrWhitespace(@Nonnull String field, @Nonnull String value, @Nullable Consumer<String> errorLogger) throws ValidationException {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return;
        }
        ValidationHelpers.handleException(new ValidationException(field, "Must not be null or empty, or comprised of whitespace", new Object[0]), errorLogger);
    }

    public static <T extends Enum<T>> void isEnumValue(@Nonnull String field, @Nullable String value, @Nonnull Class<T> enumeration, @Nullable Consumer<String> errorLogger) throws ValidationException {
        ValidationHelpers.notNull(field, value, errorLogger);
        if (value != null) {
            String[] possibles = (String[])Arrays.stream((Enum[])enumeration.getEnumConstants()).map(Enum::name).toArray(String[]::new);
            ValidationHelpers.isOneOf(field, value, true, possibles, errorLogger);
        }
    }

    public static void matchRegex(@Nonnull String field, @Nullable String value, @Nonnull String regex, @Nullable Consumer<String> errorLogger) throws ValidationException {
        ValidationHelpers.notNull(field, value, errorLogger);
        if (value != null) {
            if (Pattern.compile(regex).matcher(value).matches()) {
                return;
            }
            ValidationHelpers.handleException(new ValidationException(field, "Does \"%s\" not match regular expression \"%s\"", value, regex), errorLogger);
        }
    }

    public static void mustBeLowerCase(@Nonnull String field, @Nullable String value, @Nullable Consumer<String> errorLogger) throws ValidationException {
        ValidationHelpers.notNull(field, value, errorLogger);
        if (value != null) {
            String lower = value.toLowerCase(Locale.ROOT);
            if (lower.equals(value)) {
                return;
            }
            throw new ValidationException(field, "\"%s\" Must be in lower case", value);
        }
    }

    public static void isProperResourceLocation(@Nonnull String field, @Nullable String value, @Nullable Consumer<String> errorLogger) throws ValidationException {
        ValidationHelpers.notNull(field, value, errorLogger);
        if (value != null && !ResourceLocation.m_135830_((String)value)) {
            ValidationHelpers.handleException(new ValidationException(field, "\"%s\" is not a proper resource location", value), errorLogger);
        }
    }

    private static void handleException(@Nonnull ValidationException ex, @Nullable Consumer<String> errorLogger) throws ValidationException {
        if (errorLogger == null) {
            throw ex;
        }
        errorLogger.accept(ex.getMessage());
    }
}

