/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.world;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import org.orecruncher.lib.events.BlockUpdateEvent;
import org.orecruncher.lib.events.DiagnosticEvent;
import org.orecruncher.lib.math.LoggingTimerEMA;
import org.orecruncher.sndctrl.config.Config;

@Mod.EventBusSubscriber(modid="dsurround", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ClientBlockUpdateHandler {
    private static final int TICK_OFFSET = 10;
    private static final LoggingTimerEMA timer = new LoggingTimerEMA("Block Updates");
    private static final Queue<Pair<Integer, BlockPos>> updates = new LinkedList<Pair<Integer, BlockPos>>();
    private static final Set<BlockPos> toSend = new ObjectOpenHashSet();
    private static int interval = 0;

    private ClientBlockUpdateHandler() {
    }

    public static void blockUpdateCallback(@Nonnull ClientLevel world, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        updates.add((Pair<Integer, BlockPos>)Pair.of((Object)(interval + 10), (Object)pos));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        try {
            timer.begin();
            if (updates.isEmpty()) {
                return;
            }
            toSend.clear();
            while (!updates.isEmpty() && (Integer)updates.peek().getKey() <= interval) {
                toSend.add((BlockPos)updates.poll().getValue());
            }
            if (toSend.size() > 0) {
                BlockUpdateEvent evt = new BlockUpdateEvent(toSend);
                MinecraftForge.EVENT_BUS.post((Event)evt);
            }
        }
        finally {
            ++interval;
            timer.end();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onWorldLoad(@Nonnull WorldEvent.Load event) {
        if (event.getWorld().m_5776_()) {
            updates.clear();
            interval = 0;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onWorldUnload(@Nonnull WorldEvent.Unload event) {
        if (event.getWorld().m_5776_()) {
            updates.clear();
            interval = 0;
        }
    }

    @SubscribeEvent
    public static void onDiagnostics(@Nonnull DiagnosticEvent event) {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            event.addRenderTimer(timer);
        }
    }
}

