/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.orecruncher.dsurround.DynamicSurroundings;
import org.orecruncher.lib.logging.ModLog;
import org.orecruncher.mobeffects.config.Config;
import org.orecruncher.mobeffects.effects.EntityBowEffect;
import org.orecruncher.mobeffects.effects.EntityBreathEffect;
import org.orecruncher.mobeffects.effects.EntityFootprintEffect;
import org.orecruncher.mobeffects.effects.EntitySwingEffect;
import org.orecruncher.mobeffects.effects.PlayerToolbarEffect;
import org.orecruncher.mobeffects.library.Constants;
import org.orecruncher.mobeffects.library.Libraries;
import org.orecruncher.sndctrl.api.IMC;

@Mod(value="mobeffects")
public final class MobEffects {
    public static final String MOD_ID = "mobeffects";
    public static final ModLog LOGGER = new ModLog(MobEffects.class);

    public MobEffects() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
            MinecraftForge.EVENT_BUS.register((Object)this);
            Config.setup();
            DynamicSurroundings.doConfigMenuSetup();
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        IMC.registerSoundCategory(Constants.FOOTSTEPS, Constants.TOOLBAR);
        IMC.registerAcousticEvent(Constants.WALK, Constants.WANDER, Constants.SWIM, Constants.RUN, Constants.JUMP, Constants.LAND, Constants.CLIMB, Constants.CLIMB_RUN, Constants.DOWN, Constants.DOWN_RUN, Constants.UP, Constants.UP_RUN);
        IMC.registerEffectFactoryHandler(EntityFootprintEffect.FACTORY);
        if (((Boolean)Config.CLIENT.effects.showBreath.get()).booleanValue()) {
            IMC.registerEffectFactoryHandler(EntityBreathEffect.FACTORY);
        }
        if (((Boolean)Config.CLIENT.effects.enableBowEffect.get()).booleanValue()) {
            IMC.registerEffectFactoryHandler(EntityBowEffect.FACTORY);
        }
        if (((Boolean)Config.CLIENT.effects.enableToolbarEffect.get()).booleanValue()) {
            IMC.registerEffectFactoryHandler(PlayerToolbarEffect.FACTORY);
        }
        if (((Boolean)Config.CLIENT.effects.enableSwingEffect.get()).booleanValue()) {
            IMC.registerEffectFactoryHandler(EntitySwingEffect.FACTORY);
        }
        IMC.registerCompletionCallback(Libraries::initialize);
        IMC.registerCompletionCallback(Libraries::complete);
    }
}

