/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.effects;

import javax.annotation.Nonnull;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.random.MurmurHash3;
import org.orecruncher.mobeffects.effects.FactoryHandler;
import org.orecruncher.mobeffects.effects.particles.BubbleBreathParticle;
import org.orecruncher.mobeffects.effects.particles.FrostBreathParticle;
import org.orecruncher.sndctrl.api.effects.AbstractEntityEffect;
import org.orecruncher.sndctrl.api.effects.IEntityEffectManager;

@OnlyIn(value=Dist.CLIENT)
public class EntityBreathEffect
extends AbstractEntityEffect {
    private static final ResourceLocation NAME = new ResourceLocation("mobeffects", "breath");
    public static final FactoryHandler FACTORY = new FactoryHandler(NAME, entity -> new EntityBreathEffect());
    private int seed;

    public EntityBreathEffect() {
        super(NAME);
    }

    @Override
    public void intitialize(@Nonnull IEntityEffectManager state) {
        super.intitialize(state);
        this.seed = MurmurHash3.hash(this.getEntity().m_142049_()) & 0xFFFF;
    }

    @Override
    public void update() {
        LivingEntity entity = this.getEntity();
        if (this.isBreathVisible(entity)) {
            int c = (int)(TickCounter.getTickCount() + (long)this.seed);
            BlockPos headPos = this.getHeadPosition(entity);
            BlockState state = entity.m_20193_().m_8055_(headPos);
            if (this.showWaterBubbles(state)) {
                int air = entity.m_20146_();
                if (air > 0) {
                    int interval = c % 3;
                    if (interval == 0) {
                        this.createBubbleParticle(false);
                    }
                } else if (air == 0) {
                    for (int i = 0; i < 8; ++i) {
                        this.createBubbleParticle(true);
                    }
                }
            } else {
                int interval = c / 10 % 8;
                if (interval < 3 && this.showFrostBreath(entity, state, headPos)) {
                    this.createFrostParticle();
                }
            }
        }
    }

    protected boolean isBreathVisible(@Nonnull LivingEntity entity) {
        Player player = GameUtils.getPlayer();
        if (entity == player) {
            return !player.m_5833_() && !GameUtils.getGameSettings().f_92062_;
        }
        return !entity.m_20177_(player) && player.m_142582_((Entity)entity);
    }

    protected BlockPos getHeadPosition(@Nonnull LivingEntity entity) {
        double d0 = entity.m_20186_() + (double)entity.m_20192_();
        return new BlockPos(entity.m_20185_(), d0, entity.m_20189_());
    }

    protected boolean showWaterBubbles(@Nonnull BlockState headBlock) {
        return headBlock.m_60767_().m_76332_();
    }

    protected boolean showFrostBreath(LivingEntity entity, @Nonnull BlockState headBlock, @Nonnull BlockPos pos) {
        if (headBlock.m_60767_() == Material.f_76296_) {
            Level world = entity.m_20193_();
            return WorldUtils.isColdTemperature(WorldUtils.getTemperatureAt(world, pos));
        }
        return false;
    }

    protected void createBubbleParticle(boolean isDrowning) {
        BubbleBreathParticle p = new BubbleBreathParticle(this.getEntity(), isDrowning);
        this.addParticle((Particle)p);
    }

    protected void createFrostParticle() {
        FrostBreathParticle p = new FrostBreathParticle(this.getEntity());
        this.addParticle((Particle)p);
    }
}

