/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.effects;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.mobeffects.effects.FactoryHandler;
import org.orecruncher.mobeffects.library.ItemData;
import org.orecruncher.mobeffects.library.ItemLibrary;
import org.orecruncher.sndctrl.api.effects.AbstractEntityEffect;

@Mod.EventBusSubscriber(modid="mobeffects", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntitySwingEffect
extends AbstractEntityEffect {
    private static final long RIGHT_CLICK_GRACE = 5L;
    private static final ResourceLocation NAME = new ResourceLocation("mobeffects", "swing");
    public static final FactoryHandler FACTORY = new FactoryHandler(NAME, entity -> new EntitySwingEffect());
    private static long lastRightClick;
    protected int swingProgress = 0;
    protected boolean isSwinging = false;

    public EntitySwingEffect() {
        super(NAME);
    }

    @Override
    public void update() {
        LivingEntity entity = this.getEntity();
        if (entity.m_20202_() instanceof Boat) {
            return;
        }
        if (entity.f_20913_ > this.swingProgress && entity.f_20912_ != null) {
            if (!this.isSwinging && this.isClickOK(entity) && EntitySwingEffect.freeSwing(entity)) {
                ItemStack currentItem = entity.m_21120_(entity.f_20912_);
                ItemData data = ItemLibrary.getItemData(currentItem);
                if (this.isActivePlayer(entity)) {
                    data.playSwingSound();
                } else {
                    data.playSwingSound(entity.m_142538_());
                }
            }
            this.isSwinging = true;
        } else {
            this.isSwinging = false;
        }
        this.swingProgress = entity.f_20913_;
    }

    protected static boolean freeSwing(@Nonnull LivingEntity entity) {
        BlockHitResult result = EntitySwingEffect.rayTraceBlock(entity);
        return result.m_6662_() == HitResult.Type.MISS;
    }

    protected static double getReach(@Nonnull LivingEntity entity) {
        if (entity instanceof Player) {
            return entity.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        }
        return entity.m_20205_() * 2.0f + 0.6f;
    }

    protected static BlockHitResult rayTraceBlock(@Nonnull LivingEntity entity) {
        double range = EntitySwingEffect.getReach(entity);
        Vec3 eyes = entity.m_20299_(1.0f);
        Vec3 look = entity.m_20252_(1.0f);
        Vec3 rangedLook = eyes.m_82520_(look.f_82479_ * range, look.f_82480_ * range, look.f_82481_ * range);
        return entity.m_20193_().m_45547_(new ClipContext(eyes, rangedLook, ClipContext.Block.OUTLINE, ClipContext.Fluid.SOURCE_ONLY, (Entity)entity));
    }

    private boolean isClickOK(@Nonnull LivingEntity entity) {
        return entity == GameUtils.getPlayer() && lastRightClick < TickCounter.getTickCount() - 5L;
    }

    @SubscribeEvent
    public static void onRightClick(@Nonnull PlayerInteractEvent.RightClickItem event) {
        if (event.getSide() == LogicalSide.CLIENT) {
            lastRightClick = TickCounter.getTickCount();
        }
    }
}

