/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.footsteps;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.StringUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum Substrate {
    NORMAL("normal"),
    CARPET("carpet"),
    FOLIAGE("foliage"),
    MESSY("messy"),
    FENCE("bigger");

    private static final Map<String, Substrate> lookup;
    private final String name;

    private Substrate(String name) {
        this.name = name;
    }

    @Nonnull
    public static Substrate get(@Nullable String name) {
        return StringUtil.m_14408_((String)name) ? NORMAL : lookup.get(name);
    }

    static {
        lookup = new Object2ObjectOpenHashMap();
        for (Substrate s : Substrate.values()) {
            lookup.put(s.name, s);
        }
    }
}

