/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.library;

import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.orecruncher.dsurround.DynamicSurroundings;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.resource.IResourceAccessor;
import org.orecruncher.lib.resource.ResourceUtils;
import org.orecruncher.lib.service.IModuleService;
import org.orecruncher.lib.service.ModuleServiceManager;
import org.orecruncher.lib.validation.MapValidator;
import org.orecruncher.lib.validation.Validators;
import org.orecruncher.mobeffects.MobEffects;
import org.orecruncher.mobeffects.config.Config;
import org.orecruncher.mobeffects.library.EntityEffectInfo;
import org.orecruncher.mobeffects.library.config.EntityConfig;
import org.orecruncher.sndctrl.api.acoustics.Library;
import org.orecruncher.sndctrl.api.sound.SoundBuilder;

@Mod.EventBusSubscriber(modid="mobeffects", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class EffectLibrary {
    private static final IModLog LOGGER = MobEffects.LOGGER.createChild(EffectLibrary.class);
    private static final ResourceLocation PLAYER = new ResourceLocation("minecraft:player");
    private static final EntityEffectInfo DEFAULT;
    private static EntityEffectInfo playerEffects;
    private static final Object2ObjectOpenHashMap<ResourceLocation, EntityEffectInfo> effectConfiguration;
    private static final Reference2ObjectOpenHashMap<Class<? extends Entity>, EntityEffectInfo> effects;
    private static final Set<ResourceLocation> blockedSounds;
    private static final Map<ResourceLocation, SoundEvent> soundReplace;

    private EffectLibrary() {
    }

    static void initialize() {
        ModuleServiceManager.instance().add(new EffectLibraryService());
    }

    public static boolean hasEffect(@Nonnull Entity entity, @Nonnull ResourceLocation loc) {
        return EffectLibrary.getEffectInfo((Entity)entity).effects.contains(loc);
    }

    @Nonnull
    private static EntityEffectInfo getEffectInfo(@Nonnull Entity entity) {
        if (entity instanceof Player) {
            return playerEffects;
        }
        EntityEffectInfo eei = (EntityEffectInfo)effects.get(entity.getClass());
        if (eei == null) {
            eei = (EntityEffectInfo)effectConfiguration.get((Object)entity.m_6095_().getRegistryName());
            if (eei == null) {
                eei = DEFAULT;
            }
            effects.put(entity.getClass(), (Object)eei);
        }
        return eei;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void soundPlay(@Nonnull PlaySoundEvent e) {
        SoundInstance theSound = e.getSound();
        if (theSound != null) {
            ResourceLocation soundResource = theSound.m_7904_();
            if (blockedSounds.contains(soundResource)) {
                e.setSound(null);
            } else {
                SoundEvent evt = soundReplace.get(soundResource);
                if (evt != null) {
                    e.setSound((SoundInstance)SoundBuilder.builder(evt).from((AbstractSoundInstance)theSound).build());
                }
            }
        }
    }

    static {
        playerEffects = DEFAULT = new EntityEffectInfo();
        effectConfiguration = new Object2ObjectOpenHashMap();
        effects = new Reference2ObjectOpenHashMap();
        blockedSounds = new ObjectOpenHashSet();
        soundReplace = new Object2ObjectOpenHashMap();
    }

    private static class EffectLibraryService
    implements IModuleService {
        private static final Type entityConfigType = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, EntityConfig.class}).getType();

        private EffectLibraryService() {
        }

        @Override
        public String name() {
            return "MobEffectsLibrary";
        }

        @Override
        public void start() {
            ForgeRegistries.ENTITIES.forEach(e -> {
                if (e.m_20674_() != MobCategory.MISC) {
                    effectConfiguration.put((Object)e.getRegistryName(), (Object)DEFAULT);
                }
            });
            Collection<IResourceAccessor> configs = ResourceUtils.findConfigs("dsurround", DynamicSurroundings.DATA_PATH, "mobeffects.json");
            IResourceAccessor.process(configs, accessor -> {
                Map cfg = (Map)accessor.as(entityConfigType);
                for (Map.Entry kvp : cfg.entrySet()) {
                    EntityEffectInfo eei = new EntityEffectInfo((EntityConfig)kvp.getValue());
                    ResourceLocation loc = Library.resolveResource("mobeffects", (String)kvp.getKey());
                    effectConfiguration.put((Object)loc, (Object)eei);
                    if (loc.equals((Object)PLAYER)) {
                        playerEffects = eei;
                    }
                    for (String r : ((EntityConfig)kvp.getValue()).blockedSounds) {
                        try {
                            blockedSounds.add(new ResourceLocation(r));
                        }
                        catch (Throwable t) {
                            MobEffects.LOGGER.error(t, "Not a valid sound resource location: %s", r);
                        }
                    }
                }
            });
            ResourceLocation bowLoose = new ResourceLocation("mobeffects", "bow.loose");
            Library.getSound(bowLoose).ifPresent(se -> {
                soundReplace.put(new ResourceLocation("minecraft:entity.arrow.shoot"), (SoundEvent)se);
                soundReplace.put(new ResourceLocation("minecraft:entity.skeleton.shoot"), (SoundEvent)se);
            });
        }

        @Override
        public void log() {
            if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
                MobEffects.LOGGER.debug("MobEffect Registry", new Object[0]);
                MobEffects.LOGGER.debug("==================", new Object[0]);
                for (Object2ObjectMap.Entry kvp : effectConfiguration.object2ObjectEntrySet()) {
                    MobEffects.LOGGER.debug("%s: %s", kvp.getKey(), kvp.getValue());
                }
            }
        }

        @Override
        public void stop() {
            effectConfiguration.clear();
            effects.clear();
            blockedSounds.clear();
            soundReplace.clear();
        }

        static {
            Validators.registerValidator(entityConfigType, new MapValidator());
        }
    }
}

