/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.library;

import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2ReferenceAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.orecruncher.dsurround.DynamicSurroundings;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.resource.IResourceAccessor;
import org.orecruncher.lib.resource.ResourceUtils;
import org.orecruncher.lib.service.IModuleService;
import org.orecruncher.lib.service.ModuleServiceManager;
import org.orecruncher.mobeffects.MobEffects;
import org.orecruncher.mobeffects.library.Constants;
import org.orecruncher.mobeffects.library.ItemData;
import org.orecruncher.sndctrl.library.Primitives;

@OnlyIn(value=Dist.CLIENT)
public final class ItemLibrary {
    public static final ItemData EMPTY = new ItemData("EMPTY", Constants.NONE);
    public static final ItemData NONE = new ItemData("NONE", Constants.NONE, Constants.NONE, Constants.UTILITY_EQUIP);
    public static final ItemData LEATHER = new ItemData.ArmorItemData("LEATHER", Constants.LEATHER_ARMOR_EQUIP, Constants.LIGHT_ARMOR, Constants.LIGHT_FOOT_ARMOR, 0);
    public static final ItemData CHAIN = new ItemData.ArmorItemData("CHAIN", Constants.CHAIN_ARMOR_EQUIP, Constants.MEDIUM_ARMOR, Constants.MEDIUM_FOOT_ARMOR, 1);
    public static final ItemData CRYSTAL = new ItemData.ArmorItemData("CRYSTAL", Constants.CRYSTAL_ARMOR_EQUIP, Constants.CRYSTAL_ARMOR, Constants.CRYSTAL_FOOT_ARMOR, 2);
    public static final ItemData PLATE = new ItemData.ArmorItemData("PLATE", Constants.PLATE_ARMOR_EQUIP, Constants.HEAVY_ARMOR, Constants.HEAVY_FOOT_ARMOR, 3);
    public static final ItemData SHIELD = new ItemData("SHIELD", Constants.TOOL_SWING, Constants.SHIELD_USE, Constants.SHIELD_EQUIP);
    public static final ItemData SWORD = new ItemData("SWORD", Constants.SWORD_SWING, Constants.SWORD_SWING, Constants.SWORD_EQUIP);
    public static final ItemData AXE = new ItemData("AXE", Constants.AXE_SWING, Constants.NONE, Constants.AXE_EQUIP);
    public static final ItemData BOW = new ItemData("BOW", Constants.TOOL_SWING, Constants.BOW_PULL, Constants.BOW_EQUIP);
    public static final ItemData CROSSBOW = new ItemData("CROSSBOW", Constants.TOOL_SWING, Constants.BOW_PULL, Constants.BOW_EQUIP);
    public static final ItemData TOOL = new ItemData("TOOL", Constants.TOOL_SWING, Constants.NONE, Constants.TOOL_EQUIP);
    public static final ItemData BOOK = new ItemData("BOOK", Constants.BOOK_EQUIP, Constants.BOOK_EQUIP, Constants.BOOK_EQUIP);
    public static final ItemData POTION = new ItemData("POTION", Constants.POTION_EQUIP, Constants.POTION_EQUIP, Constants.POTION_EQUIP);
    public static final ItemData NETHERITE = new ItemData("NETHERITE", Constants.NETHERITE_ARMOR_EQUIP, Constants.NETHERITE_ARMOR_EQUIP, Constants.NETHERITE_ARMOR_EQUIP);
    private static final IModLog LOGGER = MobEffects.LOGGER.createChild(ItemLibrary.class);
    private static final Object2ReferenceAVLTreeMap<String, ItemData> CACHE = new Object2ReferenceAVLTreeMap(String.CASE_INSENSITIVE_ORDER);
    private static final String ID_PATTERN = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern FQCN = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*");
    private static final Pattern ITEM_PATTERN = Pattern.compile("([\\w\\-]+:[\\w\\.\\-/]+)[:]?(\\d+|\\*)?(\\{.*\\})?");
    private static final int SET_CAPACITY = 64;
    private static final int MAP_CAPACITY = 256;
    private static final Map<ItemData, Set<Class<?>>> classMap = new Reference2ReferenceOpenHashMap();
    private static final Map<Item, ItemData> items = new IdentityHashMap<Item, ItemData>(256);

    private ItemLibrary() {
    }

    static void initialize() {
        ModuleServiceManager.instance().add(new ItemLibraryService());
    }

    static void initFromConfig(@Nonnull Map<String, List<String>> cfg) {
        for (Map.Entry<String, List<String>> entry : cfg.entrySet()) {
            ItemLibrary.process(entry.getValue(), entry.getKey());
        }
    }

    private static ItemData resolveClass(@Nonnull Item item) {
        for (ItemData ic : CACHE.values()) {
            Set<Class<?>> itemSet = classMap.get(ic);
            if (!ItemLibrary.doesBelong(itemSet, item)) continue;
            return ic;
        }
        if (item instanceof ArmorItem) {
            ArmorItem ai = (ArmorItem)item;
            ArmorMaterial material = ai.m_40401_();
            Primitives.getArmorToolbarAcoustic(material);
            Primitives.getArmorAccentAcoustic(material);
            ResourceLocation loc = Primitives.createArmorToolbarResource(material);
            ResourceLocation armorLoc = Primitives.createArmorAccentResource(material);
            return new ItemData.ArmorItemData("adhoc", loc, armorLoc, armorLoc, 0);
        }
        return NONE;
    }

    private static boolean doesBelong(@Nonnull Set<Class<?>> itemSet, @Nonnull Item item) {
        Class<?> itemClass = item.getClass();
        if (itemSet.contains(itemClass)) {
            return true;
        }
        Optional<Class> result = itemSet.stream().filter(c -> c.isAssignableFrom(itemClass)).findFirst();
        if (result.isPresent()) {
            itemSet.add(itemClass);
            return true;
        }
        return false;
    }

    private static void process(@Nullable List<String> itemList, @Nonnull String itemClass) {
        if (itemList == null || itemList.isEmpty()) {
            return;
        }
        ItemData ic = (ItemData)CACHE.get((Object)itemClass);
        Set<Class<?>> theList = classMap.get(ic);
        for (String c : itemList) {
            Matcher match = ITEM_PATTERN.matcher(c);
            if (match.matches()) {
                String itemName = match.group(1);
                if (ResourceLocation.m_135830_((String)itemName)) {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
                    if (item != null) {
                        items.put(item, ic);
                        continue;
                    }
                    LOGGER.warn("Cannot locate item [%s] for ItemRegistry", c);
                    continue;
                }
                LOGGER.warn("Item specification [%s] is not valid", itemName);
                continue;
            }
            match = FQCN.matcher(c);
            if (match.matches()) {
                try {
                    Class<?> clazz = Class.forName(c, false, ItemLibrary.class.getClassLoader());
                    theList.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warn("Cannot locate class '%s' for ItemRegistry", c);
                }
                continue;
            }
            LOGGER.warn("Unrecognized pattern '%s' for ItemRegistry", c);
        }
    }

    @Nonnull
    public static ItemData getItemData(@Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            return NONE;
        }
        Item item = stack.m_41720_();
        ItemData data = items.get(item);
        if (data == null) {
            data = ItemLibrary.resolveClass(item);
            items.put(item, data);
        }
        return data;
    }

    static {
        CACHE.put((Object)EMPTY.getName(), (Object)EMPTY);
        CACHE.put((Object)NONE.getName(), (Object)NONE);
        CACHE.put((Object)LEATHER.getName(), (Object)LEATHER);
        CACHE.put((Object)CHAIN.getName(), (Object)CHAIN);
        CACHE.put((Object)CRYSTAL.getName(), (Object)CRYSTAL);
        CACHE.put((Object)PLATE.getName(), (Object)PLATE);
        CACHE.put((Object)SHIELD.getName(), (Object)SHIELD);
        CACHE.put((Object)SWORD.getName(), (Object)SWORD);
        CACHE.put((Object)AXE.getName(), (Object)AXE);
        CACHE.put((Object)BOW.getName(), (Object)BOW);
        CACHE.put((Object)CROSSBOW.getName(), (Object)CROSSBOW);
        CACHE.put((Object)TOOL.getName(), (Object)TOOL);
        CACHE.put((Object)BOOK.getName(), (Object)BOOK);
        CACHE.put((Object)POTION.getName(), (Object)POTION);
    }

    private static class ItemLibraryService
    implements IModuleService {
        private static final Type itemConfigType = TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType();
        private static final Type entityConfigType = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, itemConfigType}).getType();

        private ItemLibraryService() {
        }

        @Override
        public String name() {
            return "ItemLibrary";
        }

        @Override
        public void start() {
            for (ItemData ic : CACHE.values()) {
                classMap.put(ic, (Set<Class<?>>)new ReferenceOpenHashSet(64));
            }
            Collection<IResourceAccessor> configs = ResourceUtils.findConfigs("dsurround", DynamicSurroundings.DATA_PATH, "armor_accents.json");
            IResourceAccessor.process(configs, accessor -> ItemLibrary.initFromConfig((Map)accessor.as(entityConfigType)));
            for (Item item : ForgeRegistries.ITEMS) {
                if (items.containsKey(item)) continue;
                ItemData ic = ItemLibrary.resolveClass(item);
                items.put(item, ic);
            }
        }

        @Override
        public void stop() {
            items.clear();
        }
    }
}

