/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.api.acoustics;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;
import org.orecruncher.sndctrl.library.AcousticLibrary;
import org.orecruncher.sndctrl.library.SoundLibrary;

@OnlyIn(value=Dist.CLIENT)
public final class Library {
    private Library() {
    }

    @Nonnull
    public static ResourceLocation resolveResource(@Nonnull String defaultDomain, @Nonnull String name) {
        return AcousticLibrary.resolveResource(defaultDomain, name);
    }

    @Nonnull
    public static IAcoustic resolve(@Nonnull ResourceLocation acoustic) {
        return AcousticLibrary.resolve(acoustic);
    }

    @Nonnull
    public static IAcoustic resolve(@Nonnull ResourceLocation acousticName, @Nullable String definition) {
        return Library.resolve(acousticName, definition, false);
    }

    @Nonnull
    public static IAcoustic resolve(@Nonnull ResourceLocation acousticName, @Nullable String definition, boolean overwrite) {
        return AcousticLibrary.resolve(acousticName, definition, overwrite);
    }

    @Nonnull
    public static IAcoustic resolve(@Nonnull String namespace, @Nonnull String definition, @Nullable Function<ResourceLocation, IAcoustic> acousticGenerator) {
        return AcousticLibrary.resolve(namespace, definition, acousticGenerator);
    }

    @Nonnull
    public static IAcoustic resolve(@Nonnull ResourceLocation acousticName, @Nonnull ResourceLocation acousticDefinition, @Nullable Function<ResourceLocation, IAcoustic> acousticGenerator) {
        return AcousticLibrary.resolve(acousticName, acousticDefinition, acousticGenerator);
    }

    @Nonnull
    public static Optional<SoundEvent> getSound(@Nonnull ResourceLocation sound) {
        return SoundLibrary.getSound(sound);
    }
}

