/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.api.sound;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.handlers.MusicFader;
import org.orecruncher.sndctrl.config.Config;

@OnlyIn(value=Dist.CLIENT)
public class Category
implements ISoundCategory {
    private static final Map<String, ISoundCategory> nameToCategory = new HashMap<String, ISoundCategory>();
    private static final Map<SoundSource, ISoundCategory> categoryToNew = new IdentityHashMap<SoundSource, ISoundCategory>();
    public static final ISoundCategory MASTER = new SoundCategoryWrapper(SoundSource.MASTER, () -> false, () -> false);
    public static final ISoundCategory MUSIC = new FaderSoundCategoryWrapper(SoundSource.MUSIC, () -> false, () -> false);
    public static final ISoundCategory RECORDS = new FaderSoundCategoryWrapper(SoundSource.RECORDS, () -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.sound.occludeRecords).get(), () -> true);
    public static final ISoundCategory WEATHER = new SoundCategoryWrapper(SoundSource.WEATHER, () -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.sound.occludeWeather).get());
    public static final ISoundCategory BLOCKS = new SoundCategoryWrapper(SoundSource.BLOCKS);
    public static final ISoundCategory HOSTILE = new SoundCategoryWrapper(SoundSource.HOSTILE);
    public static final ISoundCategory NEUTRAL = new SoundCategoryWrapper(SoundSource.NEUTRAL);
    public static final ISoundCategory PLAYERS = new SoundCategoryWrapper(SoundSource.PLAYERS);
    public static final ISoundCategory AMBIENT = new SoundCategoryWrapper(SoundSource.AMBIENT);
    public static final ISoundCategory VOICE = new SoundCategoryWrapper(SoundSource.VOICE);
    public static final ISoundCategory CONFIG = new Category("CONFIG", "sndctrl.soundcategory.config", () -> Float.valueOf(1.0f), v -> {}, () -> false){

        @Override
        public boolean doQuickMenu() {
            return false;
        }

        @Override
        public boolean doEffects() {
            return false;
        }
    };
    private final String name;
    private final Supplier<Float> getter;
    private final Consumer<Float> setter;
    private final Supplier<Boolean> occlusion;
    private final String translationKey;

    public Category(@Nonnull String name, @Nonnull String translationKey, @Nonnull Supplier<Float> scale, @Nonnull Consumer<Float> setter) {
        this(name, translationKey, scale, setter, () -> true);
    }

    public Category(@Nonnull String name, @Nonnull String translationKey, @Nonnull Supplier<Float> scale, @Nonnull Consumer<Float> setter, @Nonnull Supplier<Boolean> occlusion) {
        this.name = name;
        this.getter = scale;
        this.setter = setter;
        this.occlusion = occlusion;
        this.translationKey = translationKey;
    }

    @Nonnull
    public static Optional<ISoundCategory> getCategory(@Nonnull String name) {
        return Optional.ofNullable(nameToCategory.get(name));
    }

    @Nonnull
    public static Optional<ISoundCategory> getCategory(@Nonnull SoundSource cat) {
        return Optional.of(categoryToNew.get(cat));
    }

    @Nonnull
    public static Optional<ISoundCategory> getCategory(@Nonnull SoundInstance sound) {
        if (sound instanceof ISoundInstance) {
            return Optional.of(((ISoundInstance)sound).getSoundCategory());
        }
        return Category.getCategory(sound.m_8070_());
    }

    public static void register(@Nonnull ISoundCategory category) {
        nameToCategory.put(category.getName(), category);
    }

    public static Collection<ISoundCategory> getCategoriesForMenu() {
        ArrayList<ISoundCategory> categories = new ArrayList<ISoundCategory>();
        for (Map.Entry<String, ISoundCategory> kvp : nameToCategory.entrySet()) {
            if (!kvp.getValue().doQuickMenu()) continue;
            categories.add(kvp.getValue());
        }
        return categories;
    }

    public static Collection<ISoundCategory> getCategories() {
        return nameToCategory.values();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public Component getTextComponent() {
        return new TranslatableComponent(this.translationKey);
    }

    @Override
    public boolean doQuickMenu() {
        return true;
    }

    @Override
    public boolean doEffects() {
        return true;
    }

    @Override
    public float getVolumeScale() {
        return this.getter.get().floatValue();
    }

    @Override
    public void setVolumeScale(float scale) {
        this.setter.accept(Float.valueOf(scale));
    }

    @Override
    public boolean doOcclusion() {
        return this.occlusion.get();
    }

    @Nonnull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getName()).add("scale", this.getVolumeScale()).toString();
    }

    static {
        categoryToNew.put(SoundSource.MASTER, MASTER);
        categoryToNew.put(SoundSource.MUSIC, MUSIC);
        categoryToNew.put(SoundSource.RECORDS, RECORDS);
        categoryToNew.put(SoundSource.WEATHER, WEATHER);
        categoryToNew.put(SoundSource.BLOCKS, BLOCKS);
        categoryToNew.put(SoundSource.HOSTILE, HOSTILE);
        categoryToNew.put(SoundSource.NEUTRAL, NEUTRAL);
        categoryToNew.put(SoundSource.PLAYERS, PLAYERS);
        categoryToNew.put(SoundSource.AMBIENT, AMBIENT);
        categoryToNew.put(SoundSource.VOICE, VOICE);
        Category.register(CONFIG);
    }

    private static class SoundCategoryWrapper
    implements ISoundCategory {
        private final SoundSource category;
        private final Supplier<Boolean> occlusion;
        private final Supplier<Boolean> effects;

        public SoundCategoryWrapper(@Nonnull SoundSource cat) {
            this(cat, () -> true, () -> true);
        }

        public SoundCategoryWrapper(@Nonnull SoundSource cat, @Nonnull Supplier<Boolean> occlusion) {
            this(cat, occlusion, () -> true);
        }

        public SoundCategoryWrapper(@Nonnull SoundSource cat, @Nonnull Supplier<Boolean> occlusion, @Nonnull Supplier<Boolean> effects) {
            this.category = cat;
            this.occlusion = occlusion;
            this.effects = effects;
            Category.register(this);
        }

        @Override
        public String getName() {
            return this.category.m_12676_();
        }

        @Override
        public Component getTextComponent() {
            return new TranslatableComponent("soundCategory." + this.getName());
        }

        @Override
        public float getVolumeScale() {
            return GameUtils.getGameSettings().m_92147_(this.category);
        }

        @Override
        public void setVolumeScale(float scale) {
            GameUtils.getGameSettings().m_92149_(this.category, scale);
        }

        @Override
        @Nonnull
        public SoundSource getRealCategory() {
            return this.category;
        }

        @Override
        public boolean doOcclusion() {
            return this.occlusion.get();
        }

        @Override
        public boolean doEffects() {
            return this.effects.get();
        }

        @Nonnull
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getName()).add("scale", this.getVolumeScale()).toString();
        }
    }

    private static class FaderSoundCategoryWrapper
    extends SoundCategoryWrapper {
        public FaderSoundCategoryWrapper(@Nonnull SoundSource cat, @Nonnull Supplier<Boolean> occlusion, @Nonnull Supplier<Boolean> effects) {
            super(cat, occlusion, effects);
        }

        @Override
        public float getVolumeScale() {
            return super.getVolumeScale() * MusicFader.getMusicScaling();
        }
    }
}

