/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.api.sound;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.random.XorShiftRandom;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.DSSoundInstance;
import org.orecruncher.sndctrl.library.SoundLibrary;

@OnlyIn(value=Dist.CLIENT)
public class SoundBuilder {
    private static final Random RANDOM = XorShiftRandom.current();
    private static final float[] volumeDelta = new float[]{-0.2f, 0.0f, 0.0f, 0.2f, 0.2f, 0.2f};
    private static final float[] pitchDelta = new float[]{-0.2f, 0.0f, 0.0f, 0.2f, 0.2f, 0.2f};
    @Nonnull
    private final SoundEvent soundEvent;
    @Nonnull
    private ISoundCategory soundCategory;
    @Nonnull
    private Vec3 position = Vec3.f_82478_;
    @Nonnull
    private SoundInstance.Attenuation attenuation = SoundInstance.Attenuation.LINEAR;
    private float volumeMin = 1.0f;
    private float volumeMax = 1.0f;
    private float pitchMin = 1.0f;
    private float pitchMax = 1.0f;
    private boolean repeatable;
    private int repeatDelayMin;
    private int repeatDelayMax;
    private boolean global;
    private boolean variableVolume;
    private boolean variablePitch;
    private int playDelay;

    public SoundBuilder(@Nonnull SoundBuilder builder) {
        this.soundEvent = builder.soundEvent;
        this.soundCategory = builder.soundCategory;
        this.position = builder.position;
        this.attenuation = builder.attenuation;
        this.volumeMin = builder.volumeMin;
        this.volumeMax = builder.volumeMax;
        this.pitchMin = builder.pitchMin;
        this.pitchMax = builder.pitchMax;
        this.repeatable = builder.repeatable;
        this.repeatDelayMin = builder.repeatDelayMin;
        this.repeatDelayMax = builder.repeatDelayMax;
        this.global = builder.global;
        this.variableVolume = builder.variableVolume;
        this.variablePitch = builder.variablePitch;
        this.playDelay = builder.playDelay;
    }

    protected SoundBuilder(@Nonnull SoundEvent evt) {
        this(evt, Category.NEUTRAL);
    }

    protected SoundBuilder(@Nonnull SoundEvent evt, @Nonnull ISoundCategory cat) {
        Objects.requireNonNull(evt);
        Objects.requireNonNull(cat);
        this.soundEvent = evt;
        this.soundCategory = cat;
    }

    @Nonnull
    public static SoundBuilder builder(@Nonnull SoundEvent evt) {
        return SoundBuilder.builder(evt, SoundLibrary.getSoundCategory(evt.m_11660_(), Category.AMBIENT));
    }

    @Nonnull
    public static SoundBuilder builder(@Nonnull SoundEvent evt, @Nonnull ISoundCategory cat) {
        return new SoundBuilder(evt, cat);
    }

    @Nonnull
    public static SoundBuilder builder(@Nonnull DSSoundInstance proto) {
        Objects.requireNonNull(proto);
        SoundEvent se = SoundLibrary.getSound(proto.m_7904_()).orElseThrow(NullPointerException::new);
        ISoundCategory sc = Category.getCategory(proto.m_8070_()).orElseThrow(NullPointerException::new);
        return new SoundBuilder(se, sc).from(proto);
    }

    @Nonnull
    public static DSSoundInstance create(@Nonnull SoundEvent evt, @Nonnull ISoundCategory cat) {
        return new DSSoundInstance(evt, cat);
    }

    @Nonnull
    public static ISoundInstance createConfigPlay(@Nonnull String name, float volume) {
        Objects.requireNonNull(name);
        ResourceLocation resource = new ResourceLocation(name);
        SoundEvent se = SoundLibrary.getSound(resource).orElseThrow(NullPointerException::new);
        ISoundCategory cat = SoundLibrary.getSoundCategory(resource, Category.MASTER);
        SoundBuilder builder = new SoundBuilder(se, cat);
        builder.setVolume(volume);
        builder.setAttenuation(SoundInstance.Attenuation.NONE);
        return builder.build();
    }

    @Nonnull
    public SoundBuilder from(@Nonnull AbstractSoundInstance ps) {
        Objects.requireNonNull(ps);
        this.soundCategory = Category.getCategory(ps.m_8070_()).orElse(Category.MASTER);
        this.position = new Vec3(ps.m_7772_(), ps.m_7780_(), ps.m_7778_());
        this.attenuation = ps.m_7438_();
        this.global = ps.m_7796_();
        this.repeatable = ps.m_7775_();
        this.repeatDelayMin = this.repeatDelayMax = ps.m_7766_();
        this.volumeMin = this.volumeMax = ps.f_119573_;
        this.pitchMin = this.pitchMax = ps.f_119574_;
        return this;
    }

    @Nonnull
    public ResourceLocation getResourceName() {
        return this.soundEvent.m_11660_();
    }

    @Nonnull
    public SoundBuilder setCategory(@Nonnull ISoundCategory cat) {
        this.soundCategory = cat;
        return this;
    }

    @Nonnull
    public SoundBuilder setPosition(float x, float y, float z) {
        this.position = new Vec3((double)x, (double)y, (double)z);
        return this;
    }

    @Nonnull
    public SoundBuilder setPosition(@Nonnull BlockPos pos) {
        Objects.requireNonNull(pos);
        return this.setPosition((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f);
    }

    @Nonnull
    public SoundBuilder setPosition(@Nonnull Vec3 pos) {
        Objects.requireNonNull(pos);
        this.position = pos;
        return this;
    }

    @Nonnull
    public SoundBuilder setVolumeRange(float min, float max) {
        this.volumeMin = MathStuff.min(min, max);
        this.volumeMax = MathStuff.max(min, max);
        this.variableVolume = false;
        return this;
    }

    @Nonnull
    public SoundBuilder setVariableVolume(boolean f) {
        this.variableVolume = f;
        if (f) {
            this.volumeMax = this.volumeMin;
        }
        return this;
    }

    @Nonnull
    public SoundBuilder setPitchRange(float min, float max) {
        this.pitchMin = MathStuff.min(min, max);
        this.pitchMax = MathStuff.max(min, max);
        this.variablePitch = false;
        return this;
    }

    @Nonnull
    public SoundBuilder setVariablePitch(boolean f) {
        this.variablePitch = f;
        if (f) {
            this.pitchMax = this.pitchMin;
        }
        return this;
    }

    @Nonnull
    public SoundBuilder setRepeateDelayRange(int min, int max) {
        this.repeatable = true;
        this.repeatDelayMin = MathStuff.min(min, max);
        this.repeatDelayMax = MathStuff.max(min, max);
        return this;
    }

    @Nonnull
    public SoundBuilder setGlobal(boolean flag) {
        this.global = flag;
        return this;
    }

    private float getVolume() {
        if (Float.compare(this.volumeMin, this.volumeMax) == 0) {
            float result = this.volumeMin;
            if (this.variableVolume) {
                result *= 1.0f + volumeDelta[RANDOM.nextInt(volumeDelta.length)];
            }
            return result;
        }
        return this.volumeMin + RANDOM.nextFloat() * (this.volumeMax - this.volumeMin);
    }

    @Nonnull
    public SoundBuilder setVolume(float v) {
        this.volumeMin = this.volumeMax = v;
        return this;
    }

    private float getPitch() {
        if (Float.compare(this.pitchMin, this.pitchMax) == 0) {
            float result = this.pitchMin;
            if (this.variablePitch) {
                result *= 1.0f + pitchDelta[RANDOM.nextInt(pitchDelta.length)];
            }
            return result;
        }
        return this.pitchMin + RANDOM.nextFloat() * (this.pitchMax - this.pitchMin);
    }

    @Nonnull
    public SoundBuilder setPitch(float p) {
        this.pitchMin = this.pitchMax = p;
        return this;
    }

    private int getRepeatDelay() {
        if (this.repeatDelayMin == this.repeatDelayMax) {
            return this.repeatDelayMin;
        }
        return this.repeatDelayMin + RANDOM.nextInt(this.repeatDelayMax - this.repeatDelayMin + 1);
    }

    @Nonnull
    public SoundBuilder setRepeatDelay(int delay) {
        this.repeatable = true;
        this.repeatDelayMin = this.repeatDelayMax = delay;
        return this;
    }

    @Nonnull
    public SoundBuilder setAttenuation(SoundInstance.Attenuation type) {
        Objects.requireNonNull(type);
        this.attenuation = type;
        return this;
    }

    @Nonnull
    public SoundBuilder setPlayDelay(int delay) {
        this.playDelay = delay;
        return this;
    }

    @Nonnull
    protected DSSoundInstance makeSound() {
        DSSoundInstance sound = SoundBuilder.create(this.soundEvent, this.soundCategory);
        sound.setVolume(this.getVolume());
        sound.setPitch(this.getPitch());
        sound.setRepeat(this.repeatable);
        sound.setRepeatDelay(this.getRepeatDelay());
        sound.setGlobal(this.global);
        sound.setPlayDelay(this.playDelay);
        if (!this.global) {
            sound.setPosition(this.position);
            sound.setAttenuationType(this.attenuation);
        } else {
            sound.setAttenuationType(SoundInstance.Attenuation.NONE);
        }
        return sound;
    }

    @Nonnull
    public ISoundInstance build() {
        return this.makeSound();
    }
}

