/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.events.DiagnosticEvent;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.sndctrl.SoundControl;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.SoundState;
import org.orecruncher.sndctrl.audio.SoundUtils;
import org.orecruncher.sndctrl.config.Config;

@OnlyIn(value=Dist.CLIENT)
public final class AudioEngine {
    private static final IModLog LOGGER = SoundControl.LOGGER.createChild(AudioEngine.class);
    private static final String FMT_DBG_SOUND_SYSTEM = ChatFormatting.AQUA + "SoundSystem: %d/%d";
    private static final String FMT_DBG_TRACKED = ChatFormatting.AQUA + "AudioEngine: %d";
    private static final String FMT_DBG_SOUND = ChatFormatting.GOLD + "%s: %d";
    private static final ReferenceOpenHashSet<ISoundInstance> playingSounds = new ReferenceOpenHashSet(256);
    @Nonnull
    private static List<String> diagnostics = ImmutableList.of();
    @Nullable
    private static SoundInstance playedSound = null;

    private AudioEngine() {
    }

    public static void stop(@Nonnull ISoundInstance sound) {
        Objects.requireNonNull(sound);
        SoundState state = sound.getState();
        if (state != SoundState.STOPPING && !state.isTerminal()) {
            if (state == SoundState.DELAYED) {
                sound.setState(SoundState.DONE);
                SoundUtils.getDelayedSounds().remove(sound);
            } else {
                sound.setState(SoundState.STOPPING);
                GameUtils.getSoundHander().m_120399_((SoundInstance)sound);
            }
        }
    }

    public static void stopAll() {
        LOGGER.debug("Stopping all sounds", new Object[0]);
        GameUtils.getSoundHander().m_120405_();
        playingSounds.forEach(s -> s.setState(SoundState.DONE));
        AudioEngine.processTerminalSounds();
    }

    public static void play(@Nonnull ISoundInstance sound) {
        Objects.requireNonNull(sound);
        if (!playingSounds.contains((Object)sound)) {
            AudioEngine.playSound0(sound);
        }
    }

    private static void playSound0(@Nonnull ISoundInstance sound) {
        sound.setState(SoundState.QUEUING);
        if (SoundUtils.isSoundVolumeBlocked(sound)) {
            sound.setState(SoundState.BLOCKED);
        } else if (sound.isDelayed()) {
            GameUtils.getSoundHander().m_120369_((SoundInstance)sound, sound.getPlayDelay());
            sound.setState(SoundState.DELAYED);
            playingSounds.add((Object)sound);
        } else if (SoundUtils.hasRoom()) {
            try {
                playedSound = null;
                GameUtils.getSoundHander().m_120367_((SoundInstance)sound);
                if (playedSound != null) {
                    if (playedSound != sound) {
                        LOGGER.debug("Sound '%s' was replaced with '%s'", sound.toString(), SoundUtils.debugString(playedSound));
                        sound.setState(SoundState.REPLACED);
                    } else {
                        playingSounds.add((Object)sound);
                        sound.setState(SoundState.PLAYING);
                    }
                } else {
                    sound.setState(SoundState.BLOCKED);
                }
            }
            catch (Throwable t) {
                sound.setState(SoundState.ERROR);
                LOGGER.error(t, "Unable to play sound '%s'", sound);
            }
            finally {
                playedSound = null;
            }
        }
        LOGGER.debug(1, () -> {
            double distance;
            if (GameUtils.getPlayer() != null) {
                Vec3 location = new Vec3(sound.m_7772_(), sound.m_7780_(), sound.m_7778_());
                distance = Math.sqrt(GameUtils.getPlayer().m_20238_(location));
            } else {
                distance = 0.0;
            }
            return String.format("%sQUEUED: [%s] (distance: %f)", sound.getState().isActive() ? "" : "NOT ", sound, distance);
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.side != LogicalSide.CLIENT || event.phase != TickEvent.Phase.START) {
            return;
        }
        Map<SoundInstance, Integer> delayedSounds = SoundUtils.getDelayedSounds();
        Map<SoundInstance, ChannelAccess.ChannelHandle> playing = SoundUtils.getPlayingSounds();
        block5: for (ISoundInstance sound : playingSounds) {
            SoundState currentState = sound.getState();
            boolean isPlaying = playing.containsKey(sound);
            switch (currentState) {
                case DELAYED: {
                    if (delayedSounds.containsKey(sound)) continue block5;
                    sound.setState(isPlaying ? SoundState.PLAYING : SoundState.DONE);
                    continue block5;
                }
                case STOPPING: {
                    if (isPlaying) continue block5;
                    sound.setState(SoundState.DONE);
                    continue block5;
                }
                case PLAYING: {
                    if (isPlaying) continue block5;
                    sound.setState(delayedSounds.containsKey(sound) ? SoundState.DELAYED : SoundState.DONE);
                    continue block5;
                }
            }
            LOGGER.debug(1, () -> String.format("Incorrect sound state [%s]", sound));
            sound.setState(SoundState.ERROR);
        }
        AudioEngine.processTerminalSounds();
        if (AudioEngine.processDiagnostics() && Minecraft.m_91087_().f_91066_.f_92063_) {
            diagnostics = new ArrayList<String>(16);
            diagnostics.add(String.format(FMT_DBG_SOUND_SYSTEM, SoundUtils.getTotalPlaying(), SoundUtils.getMaxSounds()));
            diagnostics.add(String.format(FMT_DBG_TRACKED, playingSounds.size()));
            playing.keySet().stream().map(s -> s.m_5891_().m_119787_()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(e -> String.format(FMT_DBG_SOUND, ((ResourceLocation)e.getKey()).toString(), e.getValue())).sorted().forEach(diagnostics::add);
        } else if (diagnostics.size() > 0) {
            diagnostics = ImmutableList.of();
        }
    }

    private static void processTerminalSounds() {
        playingSounds.removeIf(s -> s.getState().isTerminal());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onGatherText(@Nonnull DiagnosticEvent event) {
        if (AudioEngine.processDiagnostics() && !diagnostics.isEmpty()) {
            event.getLeft().addAll(diagnostics);
        }
    }

    private static boolean processDiagnostics() {
        return (Boolean)Config.CLIENT.logging.enableLogging.get();
    }

    public static void initialize() {
        MinecraftForge.EVENT_BUS.register(AudioEngine.class);
    }

    public static void onPlaySound(@Nonnull SoundInstance sound) {
        playedSound = sound;
        if (!(playedSound instanceof ISoundInstance)) {
            LOGGER.debug(2, () -> String.format("PLAYING: [%s]", SoundUtils.debugString(playedSound)));
        }
    }
}

