/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio;

import com.mojang.blaze3d.audio.SoundBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.sounds.AudioStream;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class Conversion {
    public static AudioStream convert(@Nonnull AudioStream inputStream) {
        AudioFormat format = inputStream.m_6206_();
        if (format.getChannels() == 1) {
            return inputStream;
        }
        return new MonoStream(inputStream);
    }

    public static SoundBuffer convert(@Nonnull SoundBuffer buffer) {
        AudioFormat format = buffer.f_83794_;
        if (format.getChannels() == 1) {
            return buffer;
        }
        int bits = format.getSampleSizeInBits();
        if (bits != 8 && bits != 16) {
            return buffer;
        }
        boolean bigendian = format.isBigEndian();
        AudioFormat monoformat = new AudioFormat(format.getEncoding(), format.getSampleRate(), bits, 1, format.getFrameSize() >> 1, format.getFrameRate(), bigendian);
        ByteBuffer source = buffer.f_83793_;
        if (source == null) {
            return buffer;
        }
        int sourceLength = source.limit();
        int skip = format.getFrameSize();
        for (int i = 0; i < sourceLength; i += skip) {
            int v;
            int c2;
            int c1;
            int targetIdx = i >> 1;
            if (bits == 8) {
                c1 = source.get(i) >> 1;
                c2 = source.get(i + 1) >> 1;
                v = c1 + c2;
                source.put(targetIdx, (byte)v);
                continue;
            }
            c1 = source.getShort(i) >> 1;
            c2 = source.getShort(i + 2) >> 1;
            v = c1 + c2;
            source.putShort(targetIdx, (short)v);
        }
        buffer.f_83794_ = monoformat;
        buffer.f_83793_.rewind();
        buffer.f_83793_.limit(sourceLength >> 1);
        return buffer;
    }

    private static class MonoStream
    implements AudioStream {
        private final AudioStream source;

        public MonoStream(@Nonnull AudioStream source) {
            this.source = source;
        }

        public AudioFormat m_6206_() {
            return this.source.m_6206_();
        }

        public ByteBuffer m_7118_(int size) throws IOException {
            return this.source.m_7118_(size);
        }

        public void close() throws IOException {
            this.source.close();
        }
    }
}

