/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.sndctrl.api.sound.IFadableSoundInstance;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.DSSoundInstance;
import org.orecruncher.sndctrl.audio.WrappedSoundInstance;

@OnlyIn(value=Dist.CLIENT)
public class FadableSoundInstance
extends WrappedSoundInstance
implements IFadableSoundInstance {
    private static final float INITIAL_FADE = 2.0E-5f;
    private static final float FADE_AMOUNT = 0.02f;
    private boolean isFading;
    private float fadeScale = 2.0E-5f;
    private float fadeScaleTarget = 1.0f;
    private boolean isDonePlaying;
    private long lastTick = TickCounter.getTickCount();

    public FadableSoundInstance(@Nonnull ISoundInstance sound, @Nonnull ISoundCategory category) {
        super(sound, category);
    }

    public FadableSoundInstance(@Nonnull ISoundInstance sound) {
        super(sound);
    }

    @Override
    public void noFade() {
        this.isFading = false;
        this.fadeScale = this.fadeScaleTarget;
    }

    @Override
    public float m_7769_() {
        return super.m_7769_() * this.fadeScale;
    }

    @Override
    public boolean m_7801_() {
        return this.isDonePlaying || super.m_7801_();
    }

    @Override
    public void m_7788_() {
        long tickDelta = TickCounter.getTickCount() - this.lastTick;
        if (tickDelta < 1L) {
            return;
        }
        super.m_7788_();
        if (this.m_7801_()) {
            return;
        }
        this.lastTick = TickCounter.getTickCount();
        if (this.fadeScale < this.fadeScaleTarget && !this.isFading()) {
            this.fadeScale += 0.02f * (float)tickDelta;
        } else if (this.isFading() || this.fadeScale > this.fadeScaleTarget) {
            this.fadeScale -= 0.02f * (float)tickDelta;
        }
        this.fadeScale = MathStuff.clamp(this.fadeScale, 0.0f, this.fadeScaleTarget);
        if (Float.compare(this.fadeScale, 0.0f) == 0) {
            this.isDonePlaying = true;
        }
    }

    @Override
    public void fade() {
        this.isFading = true;
    }

    @Override
    public void unfade() {
        this.isFading = false;
    }

    @Override
    public boolean isFading() {
        return this.isFading;
    }

    @Override
    public void setFadeVolume(float scale) {
        this.fadeScaleTarget = MathStuff.clamp1(scale);
    }

    @Nonnull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.m_7904_().toString()).addValue((Object)this.getSoundCategory().toString()).addValue((Object)this.getState().toString()).add("v", this.m_7769_()).add("ev", DSSoundInstance.getEffectiveVolume(this)).add("p", this.m_7783_()).add("f", this.fadeScale).toString();
    }
}

