/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio.acoustic;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.JsonUtils;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.sndctrl.SoundControl;
import org.orecruncher.sndctrl.api.acoustics.AcousticEvent;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.audio.acoustic.AcousticException;
import org.orecruncher.sndctrl.audio.acoustic.AcousticFactory;
import org.orecruncher.sndctrl.audio.acoustic.DelayedAcoustic;
import org.orecruncher.sndctrl.audio.acoustic.EventSelectorAcoustic;
import org.orecruncher.sndctrl.audio.acoustic.NullAcoustic;
import org.orecruncher.sndctrl.audio.acoustic.ProbabilityAcoustic;
import org.orecruncher.sndctrl.audio.acoustic.SimpleAcoustic;
import org.orecruncher.sndctrl.audio.acoustic.SimultaneousAcoustic;
import org.orecruncher.sndctrl.library.AcousticLibrary;
import org.orecruncher.sndctrl.library.SoundLibrary;

@OnlyIn(value=Dist.CLIENT)
public final class AcousticCompiler {
    public static final float DEFAULT_MIN_VOLUME = 0.9f;
    public static final float DEFAULT_MAX_VOLUME = 1.0f;
    public static final float DEFAULT_MIN_PITCH = 0.95f;
    public static final float DEFAULT_MAX_PITCH = 1.05f;
    public static final int DEFAULT_MIN_DELAY = 0;
    public static final int DEFAULT_MAX_DELAY = 0;
    private static final Gson gson = new GsonBuilder().setLenient().create();
    @Nonnull
    private final String nameSpace;
    private Map<String, IDispatchHandler> handlers = new HashMap<String, IDispatchHandler>();
    private float minVolume;
    private float maxVolume;
    private float minPitch;
    private float maxPitch;
    private int minDelay;
    private int maxDelay;

    public AcousticCompiler(@Nonnull String defaultNamespace) {
        this.nameSpace = defaultNamespace;
        this.handlers.put("simple", this::simpleHandler);
        this.handlers.put("delayed", this::delayedHandler);
        this.handlers.put("simultaneous", this::simultaneousHandler);
        this.handlers.put("probability", this::probabilityHandler);
        this.handlers.put("event", this::eventSelectorHandler);
        this.minVolume = 0.9f;
        this.maxVolume = 1.0f;
        this.minPitch = 0.95f;
        this.maxPitch = 1.05f;
        this.minDelay = 0;
        this.maxDelay = 0;
    }

    private static float getFloatSetting(@Nonnull String name, @Nonnull JsonObject obj, float defaultValue) {
        if (obj.has(name)) {
            return obj.get(name).getAsFloat() / 100.0f;
        }
        return defaultValue;
    }

    private static int getIntSetting(@Nonnull String name, @Nonnull JsonObject obj, int defaultValue) {
        if (obj.has(name)) {
            return obj.get(name).getAsInt();
        }
        return defaultValue;
    }

    private static boolean getBoolSetting(@Nonnull String name, @Nonnull JsonObject obj, boolean defaultValue) {
        if (obj.has(name)) {
            return obj.get(name).getAsBoolean();
        }
        return defaultValue;
    }

    public void setVolumeRange(float min, float max) {
        this.minVolume = min;
        this.maxVolume = max;
    }

    public void setPitchRange(float min, float max) {
        this.minPitch = min;
        this.maxPitch = max;
    }

    public void setDelayRange(int min, int max) {
        this.minDelay = min;
        this.maxDelay = max;
    }

    @Nonnull
    public static IAcoustic combine(@Nonnull ObjectArray<IAcoustic> acoustics) {
        if (acoustics.size() == 0) {
            return NullAcoustic.INSTANCE;
        }
        if (acoustics.size() == 1) {
            return acoustics.get(0);
        }
        SimultaneousAcoustic result = new SimultaneousAcoustic(new ResourceLocation("sndctrl", "adhoc"));
        acoustics.forEach(result::add);
        result.trim();
        return result;
    }

    @Nonnull
    public static IAcoustic combine(IAcoustic ... acoustics) {
        if (acoustics == null || acoustics.length == 0) {
            return NullAcoustic.INSTANCE;
        }
        if (acoustics.length == 1) {
            return acoustics[0];
        }
        SimultaneousAcoustic result = new SimultaneousAcoustic(new ResourceLocation("sndctrl", "adhoc"));
        Arrays.stream(acoustics).forEach(result::add);
        result.trim();
        return result;
    }

    @Nonnull
    public List<IAcoustic> compile(@Nonnull String acousticJson) {
        try {
            JsonObject obj = (JsonObject)gson.fromJson(acousticJson, JsonObject.class);
            return this.generate(obj.entrySet());
        }
        catch (Throwable t) {
            SoundControl.LOGGER.warn("Unable to parse acoustic: %s", t.getMessage());
            return ImmutableList.of();
        }
    }

    @Nonnull
    public List<IAcoustic> compile(@Nonnull ResourceLocation acousticFile) {
        try {
            Map<String, JsonElement> acousticList = JsonUtils.loadConfig(acousticFile, JsonElement.class);
            return this.generate(acousticList.entrySet());
        }
        catch (Throwable t) {
            SoundControl.LOGGER.warn("Unable to parse acoustic: %s", t.getMessage());
            return ImmutableList.of();
        }
    }

    @Nonnull
    private List<IAcoustic> generate(@Nonnull Set<Map.Entry<String, JsonElement>> set) {
        ArrayList<IAcoustic> result = new ArrayList<IAcoustic>();
        for (Map.Entry<String, JsonElement> kvp : set) {
            try {
                this.dispatch(kvp).ifPresent(result::add);
            }
            catch (Throwable t) {
                SoundControl.LOGGER.error(t, "Unable to parse map acoustic '%s'='%s'", kvp.getKey(), kvp.getValue().toString());
            }
        }
        return result;
    }

    @Nonnull
    private Optional<IAcoustic> dispatch(@Nonnull Map.Entry<String, JsonElement> entry) throws AcousticException {
        IDispatchHandler func;
        if (entry.getValue().isJsonPrimitive()) {
            return this.inlineHandler(entry);
        }
        JsonObject obj = entry.getValue().getAsJsonObject();
        String typeName = "simple";
        if (obj.has("type")) {
            typeName = obj.get("type").getAsString();
        }
        if ((func = this.handlers.get(typeName)) == null) {
            throw new AcousticException("Unknown acoustic type '%s'", typeName);
        }
        return func.apply(entry);
    }

    @Nonnull
    private Optional<IAcoustic> inlineHandler(@Nonnull Map.Entry<String, JsonElement> entry) throws AcousticException {
        String sound = entry.getValue().getAsString();
        if (StringUtil.m_14408_((String)sound)) {
            return Optional.of(NullAcoustic.INSTANCE);
        }
        ResourceLocation res = this.resolveResource(sound, null);
        SoundEvent evt = SoundLibrary.getSound(res).orElseThrow(IllegalStateException::new);
        ISoundCategory cat = SoundLibrary.getSoundCategory(evt.m_11660_(), Category.AMBIENT);
        return Optional.of(new SimpleAcoustic(res, new AcousticFactory(evt, cat)));
    }

    @Nonnull
    private Optional<IAcoustic> simpleHandler(@Nonnull Map.Entry<String, JsonElement> entry) throws AcousticException {
        AcousticFactory factory = this.create(entry.getValue().getAsJsonObject());
        ResourceLocation acousticId = StringUtil.m_14408_((String)entry.getKey()) ? factory.getResourceName() : this.resolveResource(entry.getKey(), null);
        return Optional.of(new SimpleAcoustic(acousticId, factory));
    }

    @Nonnull
    private Optional<IAcoustic> delayedHandler(@Nonnull Map.Entry<String, JsonElement> entry) throws AcousticException {
        JsonObject obj = entry.getValue().getAsJsonObject();
        AcousticFactory factory = this.create(obj);
        ResourceLocation acousticId = StringUtil.m_14408_((String)entry.getKey()) ? factory.getResourceName() : this.resolveResource(entry.getKey(), null);
        DelayedAcoustic da = new DelayedAcoustic(acousticId, factory);
        if (obj.has("delay")) {
            da.setDelay(AcousticCompiler.getIntSetting("delay", obj, 0));
        } else {
            da.setDelayMin(AcousticCompiler.getIntSetting("delay_min", obj, this.minDelay));
            da.setDelayMax(AcousticCompiler.getIntSetting("delay_max", obj, this.maxDelay));
        }
        return Optional.of(da);
    }

    @Nonnull
    private Optional<IAcoustic> simultaneousHandler(@Nonnull Map.Entry<String, JsonElement> entry) throws AcousticException {
        ResourceLocation acousticId = this.resolveResource(entry.getKey(), "simultaneous");
        SimultaneousAcoustic acoustic = new SimultaneousAcoustic(acousticId);
        JsonArray array = entry.getValue().getAsJsonObject().getAsJsonArray("array");
        if (array == null || array.size() == 0) {
            throw new AcousticException("Simultaneous acoustic list is null or empty '%s'", entry.toString());
        }
        for (JsonElement e : array) {
            try {
                this.dispatch(new AbstractMap.SimpleEntry<String, JsonElement>("", e)).ifPresent(acoustic::add);
            }
            catch (Throwable t) {
                SoundControl.LOGGER.error(t, "Unable to parse array acoustic '%s'", e.toString());
            }
        }
        acoustic.trim();
        return Optional.of(acoustic);
    }

    @Nonnull
    private Optional<IAcoustic> probabilityHandler(@Nonnull Map.Entry<String, JsonElement> entry) throws AcousticException {
        ResourceLocation acousticId = this.resolveResource(entry.getKey(), "probablility");
        ProbabilityAcoustic acoustic = new ProbabilityAcoustic(acousticId);
        JsonArray array = entry.getValue().getAsJsonObject().getAsJsonArray("array");
        if (array == null || array.size() == 0 || (array.size() & 1) != 0) {
            throw new AcousticException("Probability acoustic is invalid '%s'", entry.toString());
        }
        Iterator itr = array.iterator();
        while (itr.hasNext()) {
            try {
                JsonElement weight = (JsonElement)itr.next();
                if (!weight.isJsonPrimitive()) {
                    throw new AcousticException("Expected weight value '%s'", weight.toString());
                }
                JsonElement e = (JsonElement)itr.next();
                this.dispatch(new AbstractMap.SimpleEntry<String, JsonElement>("", e)).ifPresent(a -> acoustic.add((IAcoustic)a, weight.getAsInt()));
            }
            catch (Throwable t) {
                SoundControl.LOGGER.error(t, "Unable to parse probability acoustic", new Object[0]);
            }
        }
        acoustic.trim();
        return Optional.of(acoustic);
    }

    @Nonnull
    private Optional<IAcoustic> eventSelectorHandler(@Nonnull Map.Entry<String, JsonElement> entry) throws AcousticException {
        ResourceLocation acousticId = this.resolveResource(entry.getKey(), "eventSelector");
        EventSelectorAcoustic acoustic = new EventSelectorAcoustic(acousticId);
        Set entries = entry.getValue().getAsJsonObject().entrySet();
        for (Map.Entry e : entries) {
            if (((String)e.getKey()).equalsIgnoreCase("type")) continue;
            try {
                AcousticEvent ae = AcousticEvent.getEvent(AcousticLibrary.resolveResource(this.nameSpace, (String)e.getKey()));
                this.dispatch(e).ifPresent(a -> acoustic.add(ae, (IAcoustic)a));
            }
            catch (Throwable t) {
                SoundControl.LOGGER.error(t, "Unable to parse event selector acoustic entry '%s'", e.toString());
            }
        }
        return Optional.of(acoustic);
    }

    @Nonnull
    private AcousticFactory create(@Nonnull JsonObject obj) throws AcousticException {
        if (!obj.has("name")) {
            throw new AcousticException("Sound name property not found", new Object[0]);
        }
        String soundName = obj.get("name").getAsString();
        if (StringUtil.m_14408_((String)soundName)) {
            throw new AcousticException("Invalid sound name '%s'", soundName);
        }
        ResourceLocation res = this.resolveResource(soundName, null);
        SoundEvent evt = SoundLibrary.getSound(res).orElse(SoundLibrary.MISSING);
        ISoundCategory cat = null;
        if (obj.has("category")) {
            cat = Category.getCategory(obj.get("category").getAsString()).orElseThrow(() -> new AcousticException("Unknown sound category", new Object[0]));
        }
        if (cat == null) {
            cat = SoundLibrary.getSoundCategory(res, Category.NEUTRAL);
        }
        AcousticFactory builder = new AcousticFactory(evt);
        builder.setCategory(cat);
        if (obj.has("pitch")) {
            builder.setPitch(AcousticCompiler.getFloatSetting("pitch", obj, 1.0f));
        } else {
            float pitchMin = AcousticCompiler.getFloatSetting("pitch_min", obj, this.minPitch);
            float pitchMax = AcousticCompiler.getFloatSetting("pitch_max", obj, this.maxPitch);
            builder.setPitchRange(pitchMin, pitchMax);
        }
        if (obj.has("volume")) {
            builder.setVolume(AcousticCompiler.getFloatSetting("volume", obj, 1.0f));
        } else {
            float volMin = AcousticCompiler.getFloatSetting("vol_min", obj, this.minVolume);
            float volMax = AcousticCompiler.getFloatSetting("vol_max", obj, this.maxVolume);
            builder.setVolumeRange(volMin, volMax);
        }
        boolean repeat = AcousticCompiler.getBoolSetting("repeatable", obj, false);
        if (repeat) {
            if (obj.has("repeat_delay")) {
                builder.setRepeatDelay(AcousticCompiler.getIntSetting("repeat_delay", obj, 0));
            } else {
                int delayMin = AcousticCompiler.getIntSetting("repeat_delay_min", obj, 0);
                int delayMax = AcousticCompiler.getIntSetting("repeat_delay_max", obj, 0);
                builder.setRepeateDelayRange(delayMin, delayMax);
            }
        }
        boolean global = AcousticCompiler.getBoolSetting("global", obj, false);
        builder.setGlobal(global);
        return builder;
    }

    @Nonnull
    private ResourceLocation resolveResource(@Nonnull String name, @Nullable String defaultName) throws AcousticException {
        String n = name;
        if (StringUtil.m_14408_((String)n)) {
            n = defaultName;
        }
        if (StringUtil.m_14408_((String)n)) {
            throw new AcousticException("Sound name is null or empty", new Object[0]);
        }
        return AcousticLibrary.resolveResource(this.nameSpace, n);
    }

    @FunctionalInterface
    private static interface IDispatchHandler {
        public Optional<IAcoustic> apply(@Nonnull Map.Entry<String, JsonElement> var1) throws AcousticException;
    }

    private static class Constants {
        public static final String TYPE = "type";
        public static final String NAME = "name";
        public static final String CATEGORY = "category";
        public static final String MIN_PITCH = "pitch_min";
        public static final String MAX_PITCH = "pitch_max";
        public static final String PITCH = "pitch";
        public static final String MIN_VOLUME = "vol_min";
        public static final String MAX_VOLUME = "vol_max";
        public static final String VOLUME = "volume";
        public static final String MIN_DELAY = "delay_min";
        public static final String MAX_DELAY = "delay_max";
        public static final String DELAY = "delay";
        public static final String REPEATABLE = "repeatable";
        public static final String REPEAT_DELAY = "repeat_delay";
        public static final String MIN_REPEAT_DELAY = "repeat_delay_min";
        public static final String MAX_REPEAT_DELAY = "repeat_delay_max";
        public static final String GLOBAL = "global";
        public static final String ARRAY = "array";

        private Constants() {
        }
    }
}

