/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio.acoustic;

import com.google.common.base.MoreObjects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.random.XorShiftRandom;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.acoustic.AcousticFactory;
import org.orecruncher.sndctrl.audio.acoustic.SimpleAcoustic;

@OnlyIn(value=Dist.CLIENT)
public class DelayedAcoustic
extends SimpleAcoustic {
    private static final Random RANDOM = XorShiftRandom.current();
    private int delayMin;
    private int delayMax;

    public DelayedAcoustic(@Nonnull ResourceLocation name, @Nonnull AcousticFactory factory) {
        super(name, factory);
    }

    public void setDelay(int delay) {
        this.delayMin = this.delayMax = delay;
    }

    public void setDelayMin(int min) {
        this.delayMin = min;
    }

    public void setDelayMax(int max) {
        this.delayMax = max;
    }

    public boolean hasDelay() {
        return this.delayMax > 0;
    }

    @Override
    protected void play(@Nonnull ISoundInstance sound) {
        if (this.hasDelay()) {
            int delay = this.delayMin;
            if (this.delayMax > this.delayMin) {
                delay += RANDOM.nextInt(this.delayMax - this.delayMin);
            }
            sound.setPlayDelay(delay);
        }
        super.play(sound);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getName().toString()).toString();
    }
}

