/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio.handlers;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.Utilities;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.handlers.SoundProcessor;

@OnlyIn(value=Dist.CLIENT)
public final class SoundVolumeEvaluator {
    private static final ObjectArray<Function<SoundInstance, Float>> volumeScaleCallbacks = new ObjectArray();

    private SoundVolumeEvaluator() {
    }

    public static void register(@Nonnull Function<SoundInstance, Float> callback) {
        volumeScaleCallbacks.add(callback);
    }

    private static float getVolumeScaleFromMods(@Nonnull SoundInstance sound) {
        float result = SoundProcessor.getVolumeScale(sound);
        for (Function<SoundInstance, Float> callback : volumeScaleCallbacks) {
            try {
                if ((result = MathStuff.min(result, callback.apply(sound).floatValue())) != 0.0f) continue;
                break;
            }
            catch (Throwable throwable) {
            }
        }
        return MathStuff.clamp(result, 0.0f, 4.0f);
    }

    private static float getCategoryVolumeScale(@Nonnull SoundInstance sound) {
        Optional<ISoundInstance> si = Utilities.safeCast(sound, ISoundInstance.class);
        if (si.isPresent()) {
            ISoundCategory sc = si.get().getSoundCategory();
            return sc == Category.MASTER ? 1.0f : sc.getVolumeScale();
        }
        SoundSource category = sound.m_8070_();
        return category == SoundSource.MASTER ? 1.0f : GameUtils.getGameSettings().m_92147_(category);
    }

    public static float getClampedVolume(@Nonnull SoundInstance sound) {
        ISoundCategory sc;
        if (sound instanceof ISoundInstance && (sc = ((ISoundInstance)sound).getSoundCategory()) == Category.CONFIG) {
            return sound.m_7769_();
        }
        Preconditions.checkNotNull((Object)sound);
        float volume = SoundVolumeEvaluator.getVolumeScaleFromMods(sound) * SoundVolumeEvaluator.getCategoryVolumeScale(sound) * sound.m_7769_();
        return MathStuff.clamp1(volume);
    }
}

