/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio.handlers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.sndctrl.library.AudioEffectLibrary;

@OnlyIn(value=Dist.CLIENT)
public final class WorldContext {
    public final Minecraft mc;
    public final Player player;
    public final LevelReader world;
    public final Vec3 playerPosition;
    public final Vec3 playerEyePosition;
    public final BlockPos playerPos;
    public final BlockPos playerEyePos;
    public final boolean isPrecipitating;
    public final float precipitationStrength;
    public final float auralDampening;

    public WorldContext() {
        if (GameUtils.isInGame()) {
            ClientLevel w = GameUtils.getWorld();
            this.world = w;
            assert (this.world != null);
            this.player = GameUtils.getPlayer();
            assert (this.player != null);
            this.isPrecipitating = w.m_46471_();
            this.playerPosition = this.player.m_20182_();
            this.playerEyePosition = this.player.m_20299_(1.0f);
            this.playerPos = new BlockPos(this.playerPosition);
            this.playerEyePos = new BlockPos(this.playerEyePosition);
            Fluid fs = this.player.f_19853_.m_6425_(this.playerEyePos).m_76152_();
            ResourceLocation name = fs.getRegistryName();
            this.auralDampening = name != null ? AudioEffectLibrary.getFluidCoeffcient(name) : 0.0f;
            this.precipitationStrength = WorldUtils.getRainStrength((Level)w, 1.0f);
            this.mc = Minecraft.m_91087_();
        } else {
            this.mc = null;
            this.player = null;
            this.world = null;
            this.isPrecipitating = false;
            this.playerPosition = Vec3.f_82478_;
            this.playerEyePosition = Vec3.f_82478_;
            this.playerPos = BlockPos.f_121853_;
            this.playerEyePos = BlockPos.f_121853_;
            this.auralDampening = 0.0f;
            this.precipitationStrength = 0.0f;
        }
    }

    public boolean isNotValid() {
        return this.mc == null;
    }
}

