/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.util.Translator;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.core.config.IClientConfig;
import mezz.jei.events.EditModeToggleEvent;
import mezz.jei.events.RuntimeEventSubscriptions;
import mezz.jei.gui.ingredients.IListElement;
import mezz.jei.gui.overlay.IFilterTextSource;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.ingredients.IIngredientSorter;
import mezz.jei.ingredients.IListElementInfo;
import mezz.jei.ingredients.IngredientVisibility;
import mezz.jei.ingredients.ListElementInfo;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.search.ElementPrefixParser;
import mezz.jei.search.ElementSearch;
import mezz.jei.search.ElementSearchLowMem;
import mezz.jei.search.IElementSearch;
import net.minecraft.core.NonNullList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class IngredientFilter
implements IIngredientGridSource {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern FILTER_SPLIT_PATTERN = Pattern.compile("(-?\".*?(?:\"|$)|\\S+)");
    private final IFilterTextSource filterTextSource;
    private final RegisteredIngredients registeredIngredients;
    private final IIngredientSorter sorter;
    private final IngredientVisibility ingredientVisibility;
    private final IElementSearch elementSearch;
    private final ElementPrefixParser elementPrefixParser;
    private final Set<String> modNamesForSorting = new HashSet<String>();
    @Nullable
    private List<ITypedIngredient<?>> ingredientListCached;
    private final List<IIngredientGridSource.SourceListChangedListener> listeners = new ArrayList<IIngredientGridSource.SourceListChangedListener>();

    public IngredientFilter(IFilterTextSource filterTextSource, IClientConfig clientConfig, IIngredientFilterConfig config, RegisteredIngredients registeredIngredients, IIngredientSorter sorter, NonNullList<IListElement<?>> ingredients, IModIdHelper modIdHelper, IngredientVisibility ingredientVisibility) {
        this.filterTextSource = filterTextSource;
        this.registeredIngredients = registeredIngredients;
        this.sorter = sorter;
        this.ingredientVisibility = ingredientVisibility;
        this.elementPrefixParser = new ElementPrefixParser(registeredIngredients, config);
        this.elementSearch = clientConfig.isLowMemorySlowSearchEnabled() ? new ElementSearchLowMem() : new ElementSearch(this.elementPrefixParser);
        LOGGER.info("Adding {} ingredients", (Object)ingredients.size());
        ingredients.stream().map(i -> ListElementInfo.create(i, registeredIngredients, modIdHelper)).filter(Objects::nonNull).forEach(this::addIngredient);
        LOGGER.info("Added {} ingredients", (Object)ingredients.size());
        this.filterTextSource.addListener(filterText -> {
            this.ingredientListCached = null;
            this.notifyListenersOfChange();
        });
    }

    public void register(RuntimeEventSubscriptions subscriptions) {
        subscriptions.register(EditModeToggleEvent.class, event -> this.updateHidden());
    }

    public <V> void addIngredient(IListElementInfo<V> info) {
        IListElement<V> element = info.getElement();
        this.updateHiddenState(element);
        this.elementSearch.add(info);
        String modNameForSorting = info.getModNameForSorting();
        this.modNamesForSorting.add(modNameForSorting);
        this.invalidateCache();
    }

    public void invalidateCache() {
        this.ingredientListCached = null;
        this.sorter.invalidateCache();
    }

    public <V> Optional<IListElementInfo<V>> searchForMatchingElement(IIngredientHelper<V> ingredientHelper, ITypedIngredient<V> typedIngredient) {
        V ingredient = typedIngredient.getIngredient();
        IIngredientType type = typedIngredient.getType();
        Function<ITypedIngredient, String> uidFunction = i -> ingredientHelper.getUniqueId(i.getIngredient(), UidContext.Ingredient);
        String ingredientUid = uidFunction.apply(typedIngredient);
        String displayName = ingredientHelper.getDisplayName(ingredient);
        String lowercaseDisplayName = Translator.toLowercaseWithLocale(displayName);
        ElementPrefixParser.TokenInfo tokenInfo = new ElementPrefixParser.TokenInfo(lowercaseDisplayName, ElementPrefixParser.NO_PREFIX);
        return this.elementSearch.getSearchResults(tokenInfo).stream().map(elementInfo -> IngredientFilter.checkForMatch(elementInfo, type, ingredientUid, uidFunction)).flatMap(Optional::stream).findFirst();
    }

    public void updateHidden() {
        boolean changed = false;
        for (IListElementInfo<?> info : this.elementSearch.getAllIngredients()) {
            IListElement<?> element = info.getElement();
            changed |= this.updateHiddenState(element);
        }
        if (changed) {
            this.ingredientListCached = null;
            this.notifyListenersOfChange();
        }
    }

    public <V> boolean updateHiddenState(IListElement<V> element) {
        ITypedIngredient<V> typedIngredient = element.getTypedIngredient();
        boolean visible = this.ingredientVisibility.isIngredientVisible(typedIngredient);
        if (element.isVisible() != visible) {
            element.setVisible(visible);
            return true;
        }
        return false;
    }

    @Override
    public List<ITypedIngredient<?>> getIngredientList() {
        String filterText = this.filterTextSource.getFilterText();
        filterText = filterText.toLowerCase();
        if (this.ingredientListCached == null) {
            this.ingredientListCached = this.getIngredientListUncached(filterText);
        }
        return this.ingredientListCached;
    }

    public @Unmodifiable List<IListElementInfo<?>> getIngredientListPreSort(Comparator<IListElementInfo<?>> directComparator) {
        return this.elementSearch.getAllIngredients().stream().sorted(directComparator).toList();
    }

    public Set<String> getModNamesForSorting() {
        return Collections.unmodifiableSet(this.modNamesForSorting);
    }

    public <T> List<T> getFilteredIngredients(IIngredientType<T> ingredientType) {
        return this.getIngredientList().stream().map(i -> i.getIngredient(ingredientType)).flatMap(Optional::stream).toList();
    }

    private List<ITypedIngredient<?>> getIngredientListUncached(String filterText) {
        String[] filters = filterText.split("\\|");
        List<SearchTokens> searchTokens = Arrays.stream(filters).map(this::parseSearchTokens).filter(s -> !s.toSearch.isEmpty()).toList();
        Stream<IListElementInfo<Object>> elementInfoStream = searchTokens.isEmpty() ? this.elementSearch.getAllIngredients().parallelStream() : searchTokens.stream().map(this::getSearchResults).flatMap(Collection::stream).distinct();
        return elementInfoStream.filter(info -> info.getElement().isVisible()).sorted(this.sorter.getComparator(this, this.registeredIngredients)).map(IListElementInfo::getTypedIngredient).toList();
    }

    public <T> List<ITypedIngredient<T>> searchForWildcardMatches(ITypedIngredient<T> typedIngredient, IIngredientHelper<T> ingredientHelper, Function<ITypedIngredient<T>, String> wildcardUidFunction) {
        ITypedIngredient<?> ingredient;
        Optional<ITypedIngredient<T>> match;
        int i;
        IIngredientType<T> ingredientType = typedIngredient.getType();
        Optional<IListElementInfo<T>> searchResult = this.searchForMatchingElement(ingredientHelper, typedIngredient);
        if (searchResult.isEmpty()) {
            return List.of();
        }
        String wildcardUid = wildcardUidFunction.apply(typedIngredient);
        String itemUid = ingredientHelper.getUniqueId(typedIngredient.getIngredient(), UidContext.Ingredient);
        if (itemUid.equals(wildcardUid)) {
            return List.of(searchResult.get().getTypedIngredient());
        }
        IntOpenHashSet matchingIndexes = new IntOpenHashSet();
        ArrayList<ITypedIngredient<T>> matchingElements = new ArrayList<ITypedIngredient<T>>();
        IListElementInfo<T> matchingElement = searchResult.get();
        List<ITypedIngredient<?>> ingredientList = this.getIngredientListUncached("");
        int startingIndex = ingredientList.indexOf(matchingElement.getTypedIngredient());
        matchingIndexes.add(startingIndex);
        matchingElements.add(matchingElement.getTypedIngredient());
        for (i = startingIndex - 1; i >= 0 && !matchingIndexes.contains(i) && !(match = IngredientFilter.checkForMatch(ingredient = ingredientList.get(i), ingredientType, wildcardUid, wildcardUidFunction)).isEmpty(); --i) {
            matchingIndexes.add(i);
            matchingElements.add(match.get());
        }
        for (i = startingIndex + 1; i < ingredientList.size() && !matchingIndexes.contains(i) && !(match = IngredientFilter.checkForMatch(ingredient = ingredientList.get(i), ingredientType, wildcardUid, wildcardUidFunction)).isEmpty(); ++i) {
            matchingIndexes.add(i);
            matchingElements.add(match.get());
        }
        return matchingElements;
    }

    private static <T> Optional<IListElementInfo<T>> checkForMatch(IListElementInfo<?> info, IIngredientType<T> ingredientType, String uid, Function<ITypedIngredient<T>, String> uidFunction) {
        return IngredientFilter.optionalCast(info, ingredientType).filter(cast -> {
            ITypedIngredient typedIngredient = cast.getTypedIngredient();
            String elementUid = (String)uidFunction.apply(typedIngredient);
            return uid.equals(elementUid);
        });
    }

    private static <T> Optional<IListElementInfo<T>> optionalCast(IListElementInfo<?> info, IIngredientType<T> ingredientType) {
        ITypedIngredient<?> typedIngredient = info.getTypedIngredient();
        if (typedIngredient.getType() == ingredientType) {
            IListElementInfo<?> cast = info;
            return Optional.of(cast);
        }
        return Optional.empty();
    }

    private static <T> Optional<ITypedIngredient<T>> checkForMatch(ITypedIngredient<?> typedIngredient, IIngredientType<T> ingredientType, String uid, Function<ITypedIngredient<T>, String> uidFunction) {
        return IngredientFilter.optionalCast(typedIngredient, ingredientType).filter(cast -> {
            String elementUid = (String)uidFunction.apply((ITypedIngredient)cast);
            return uid.equals(elementUid);
        });
    }

    private static <T> Optional<ITypedIngredient<T>> optionalCast(ITypedIngredient<?> typedIngredient, IIngredientType<T> ingredientType) {
        if (typedIngredient.getType() == ingredientType) {
            ITypedIngredient<?> cast = typedIngredient;
            return Optional.of(cast);
        }
        return Optional.empty();
    }

    private SearchTokens parseSearchTokens(String filterText) {
        SearchTokens searchTokens = new SearchTokens(new ArrayList<ElementPrefixParser.TokenInfo>(), new ArrayList<ElementPrefixParser.TokenInfo>());
        if (filterText.isEmpty()) {
            return searchTokens;
        }
        Matcher filterMatcher = FILTER_SPLIT_PATTERN.matcher(filterText);
        while (filterMatcher.find()) {
            String string = filterMatcher.group(1);
            boolean remove = string.startsWith("-");
            if (remove) {
                string = string.substring(1);
            }
            if ((string = QUOTE_PATTERN.matcher(string).replaceAll("")).isEmpty()) continue;
            this.elementPrefixParser.parseToken(string).ifPresent(result -> {
                if (remove) {
                    searchTokens.toRemove.add((ElementPrefixParser.TokenInfo)result);
                } else {
                    searchTokens.toSearch.add((ElementPrefixParser.TokenInfo)result);
                }
            });
        }
        return searchTokens;
    }

    private Set<IListElementInfo<?>> getSearchResults(SearchTokens searchTokens) {
        List resultsPerToken = searchTokens.toSearch.stream().map(this.elementSearch::getSearchResults).toList();
        Set<IListElementInfo<IListElementInfo<?>>> results = IngredientFilter.intersection(resultsPerToken);
        if (!results.isEmpty() && !searchTokens.toRemove.isEmpty()) {
            for (ElementPrefixParser.TokenInfo tokenInfo : searchTokens.toRemove) {
                Set<IListElementInfo<?>> resultsToRemove = this.elementSearch.getSearchResults(tokenInfo);
                results.removeAll(resultsToRemove);
                if (!results.isEmpty()) continue;
                break;
            }
        }
        return results;
    }

    private static <T> Set<T> intersection(List<Set<T>> sets) {
        Set<T> set;
        Set smallestSet = sets.stream().min(Comparator.comparing(Set::size)).orElseGet(Set::of);
        Set results = Collections.newSetFromMap(new IdentityHashMap());
        results.addAll(smallestSet);
        Iterator<Set<T>> iterator = sets.iterator();
        while (!(!iterator.hasNext() || (set = iterator.next()) != smallestSet && results.retainAll(set) && results.isEmpty())) {
        }
        return results;
    }

    @Override
    public void addSourceListChangedListener(IIngredientGridSource.SourceListChangedListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListenersOfChange() {
        for (IIngredientGridSource.SourceListChangedListener listener : this.listeners) {
            listener.onSourceListChanged();
        }
    }

    private record SearchTokens(List<ElementPrefixParser.TokenInfo> toSearch, List<ElementPrefixParser.TokenInfo> toRemove) {
    }
}

