/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lock_and_key;

import com.legacy.lock_and_key.LockAndKeyMod;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LockEvents {
    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity blockEntity;
        BlockState block = event.getWorld().m_8055_(event.getPos());
        Level world = event.getWorld();
        if (!world.f_46443_ && block.m_155947_() && (blockEntity = world.m_7702_(event.getPos())) instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity lockedTile = (BaseContainerBlockEntity)blockEntity;
            if (event.getPlayer().m_21205_().m_41720_() == LockAndKeyMod.Registry.KEY.get() && !LockEvents.isNeighborLocked(lockedTile, event.getPlayer())) {
                if (lockedTile.f_58621_ == LockCode.f_19102_ && !event.getPlayer().m_6144_()) {
                    if (event.getPlayer().m_21205_().m_41720_() == LockAndKeyMod.Registry.KEY.get() && !event.getPlayer().m_21205_().m_41788_()) {
                        event.getPlayer().m_5661_((Component)new TranslatableComponent("gui.lock_and_key.no_name"), true);
                        world.m_5594_(null, event.getPos(), SoundEvents.f_11724_, SoundSource.BLOCKS, 1.0f, 1.5f);
                    } else {
                        lockedTile.f_58621_ = new LockCode(event.getPlayer().m_21205_().m_41786_().getString());
                        event.getPlayer().m_5661_((Component)new TranslatableComponent("gui.lock_and_key.locked", new Object[]{lockedTile.m_5446_()}), true);
                        world.m_5594_(null, event.getPos(), SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 0.5f);
                    }
                    event.setCanceled(true);
                } else if (lockedTile.f_58621_ != LockCode.f_19102_ && event.getPlayer().m_6144_() && LockEvents.canUnlockTile(lockedTile.f_58621_, event.getPlayer().m_21205_())) {
                    event.getPlayer().m_21011_(InteractionHand.MAIN_HAND, true);
                    lockedTile.f_58621_ = LockCode.f_19102_;
                    event.getPlayer().m_5661_((Component)new TranslatableComponent("gui.lock_and_key.unlocked", new Object[]{lockedTile.m_5446_()}), true);
                    world.m_5594_(null, event.getPos(), SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.5f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockEntity blockEntity;
        Level world = event.getPlayer().f_19853_;
        BlockState block = event.getState();
        if (!world.f_46443_ && block.m_155947_() && (blockEntity = world.m_7702_(event.getPos())) instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity lockedTile = (BaseContainerBlockEntity)blockEntity;
            if (!(event.getPlayer().m_7500_() || LockEvents.canOpenChest(event.getPlayer(), lockedTile.f_58621_, null) && !LockEvents.isNeighborLocked(lockedTile, event.getPlayer()))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        ArrayList blocks = new ArrayList(event.getAffectedBlocks());
        Level level = event.getWorld();
        blocks.forEach(position -> {
            BlockEntity patt3806$temp;
            if (!level.f_46443_ && (patt3806$temp = level.m_7702_(position)) instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity tile = (BaseContainerBlockEntity)patt3806$temp;
                if (tile.f_58621_ != LockCode.f_19102_ || LockEvents.getNeighborChest(tile) != null && LockEvents.getNeighborChest((BaseContainerBlockEntity)tile).f_58621_ != LockCode.f_19102_) {
                    event.getAffectedBlocks().remove(position);
                }
            }
        });
    }

    public static boolean canOpenChest(Player player, LockCode code, Component nameIn) {
        if (player.m_7500_()) {
            return true;
        }
        boolean canUnlock = LockEvents.canUnlockTile(code, player.m_21205_());
        if (!player.m_5833_() && !canUnlock && player.m_21205_().m_41720_() == LockAndKeyMod.Registry.KEY.get()) {
            if (nameIn != null) {
                player.m_5661_((Component)new TranslatableComponent("gui.lock_and_key.wrong_key", new Object[]{nameIn}), true);
                player.m_6330_(SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return false;
        }
        if (!player.m_5833_() && !canUnlock) {
            if (nameIn != null) {
                player.m_5661_((Component)new TranslatableComponent("container.isLocked", new Object[]{nameIn}), true);
                player.m_6330_(SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return false;
        }
        return true;
    }

    private static boolean canUnlockTile(LockCode lockCode, ItemStack stack) {
        return lockCode.f_19103_.isEmpty() || !stack.m_41619_() && stack.m_41788_() && lockCode.f_19103_.equals(stack.m_41786_().getString()) && stack.m_41720_() == LockAndKeyMod.Registry.KEY.get();
    }

    private static boolean isNeighborLocked(BaseContainerBlockEntity tile, Player player) {
        ChestBlockEntity neighbor = LockEvents.getNeighborChest(tile);
        if (neighbor != null) {
            return !LockEvents.canOpenChest(player, neighbor.f_58621_, null);
        }
        return false;
    }

    private static ChestBlockEntity getNeighborChest(BaseContainerBlockEntity tile) {
        BlockEntity blockEntity;
        if (tile instanceof ChestBlockEntity && tile.m_58900_().m_61138_((Property)ChestBlock.f_51479_) && tile.m_58900_().m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE && tile.m_58898_() && (blockEntity = tile.m_58904_().m_7702_(tile.m_58899_().m_142300_(ChestBlock.m_51584_((BlockState)tile.m_58900_())))) instanceof ChestBlockEntity) {
            ChestBlockEntity neighbor = (ChestBlockEntity)blockEntity;
            return neighbor;
        }
        return null;
    }
}

